package com.biz.crm.cps.business.policy.display.ladder.local.utils;

import com.biz.crm.cps.bisiness.policy.display.sdk.common.constant.DisplayConstant;
import org.apache.commons.lang3.StringUtils;

import java.util.Calendar;
import java.util.Date;

/**
 * @author HuaHongQiang
 * @date 2021/8/20 10:01
 * 定时任务工具类
 */
public class DisplaySchedulerUtils {
  /**
   * 每个自然月执行一次cron
   */
  public static final String CRON_MONTH = "0 0 0 1 1/1 ?";
  /**
   * 每3个自然月执行一次cron
   */
  public static final String CRON_SEASON = "0 0 0 1 1/3 ?";
  /**
   * 每6个自然月执行一次cron
   */
  public static final String CRON_HALF_YEAR = "0 0 0 1 1/6 ?";
  /**
   * 每个自然年执行一次cron
   */
  public static final String CRON_YEAR = "0 0 0 1 1 ?";
  /**
   * 定时任务，每个自然月执行一次cron
   */
  public static final String CRON_DAY = "0 0 0 * * ?";
  /**
   * 定时任务，1月1号00:00:00执行一次cron
   */
  public static final String CRON_JAN = "0 0 0 1 1 ?";

  /**
   * 定时任务，2月1号00:00:00执行一次cron
   */
  public static final String CRON_FEB = "0 0 0 1 2 ?";

  /**
   * 定时任务，3月1号00:00:00执行一次cron
   */
  public static final String CRON_MAR = "0 0 0 1 3 ?";

  /**
   * 定时任务，4月1号00:00:00执行一次cron
   */
  public static final String CRON_APR = "0 0 0 1 4 ?";

  /**
   * 定时任务，5月1号00:00:00执行一次cron
   */
  public static final String CRON_MAY = "0 0 0 1 5 ?";

  /**
   * 定时任务，6月1号00:00:00执行一次cron
   */
  public static final String CRON_JUN = "0 0 0 1 6 ?";

  /**
   * 定时任务，7月1号00:00:00执行一次cron
   */
  public static final String CRON_JUL = "0 0 0 1 7 ?";

  /**
   * 定时任务，8月1号00:00:00执行一次cron
   */
  public static final String CRON_AUG = "0 0 0 1 8 ?";

  /**
   * 定时任务，9月1号00:00:00执行一次cron
   */
  public static final String CRON_SEP = "0 0 0 1 9 ?";

  /**
   * 定时任务，10月1号00:00:00执行一次cron
   */
  public static final String CRON_OCT = "0 0 0 1 10 ?";

  /**
   * 定时任务，11月1号00:00:00执行一次cron
   */
  public static final String CRON_NOV = "0 0 0 1 11 ?";


  /**
   * 定时任务，12月1号00:00:00执行一次cron
   */
  public static final String CRON_DEC = "0 0 0 1 12 ?";

  /**
   * 根据时间类别获取定时任务cron表达式
   *
   * @param endTime 任务结束时间
   * @return cron表达式
   */
  public static String getSchedulerCron(Date endTime) {
    if (endTime == null) {
      return CRON_MONTH;
    }
    Calendar calendar = Calendar.getInstance();
    calendar.setTime(endTime);
    int month = calendar.get(Calendar.MONTH) + 1;

    switch (month) {
      case 1:
        return CRON_FEB;
      case 2:
        return CRON_MAR;
      case 3:
        return CRON_APR;
      case 4:
        return CRON_MAY;
      case 5:
        return CRON_JUN;
      case 6:
        return CRON_JUL;
      case 7:
        return CRON_AUG;
      case 8:
        return CRON_SEP;
      case 9:
        return CRON_OCT;
      case 10:
        return CRON_NOV;
      case 11:
        return CRON_DEC;
      case 12:
        return CRON_JAN;
        //默认返回每月表达式
      default:
        return CRON_MONTH;
    }
  }

  /**
   * 根据时间类别获取定时任务cron表达式
   *
   * @param dateType 时间类别(年/月/半年/季度)
   * @return cron表达式
   */
  public static String getSchedulerCron(String dateType) {
    //临时修改为每小时执行一次
    if (StringUtils.isBlank(dateType)) {
      return CRON_MONTH;
    }
    switch (dateType) {
      case DisplayConstant.YEAR:
        return CRON_YEAR;
      case DisplayConstant.HALF_YEAR:
        return CRON_HALF_YEAR;
      case DisplayConstant.SEASON:
        return CRON_SEASON;
      case DisplayConstant.MONTH:
        //默认返回月度表达式
      default:
        return CRON_MONTH;
    }
  }
}
