/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.display.ladder.local.service.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.DisplayTaskStatusNewEnum;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayCalculateTask;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTaskScanCode;
import com.biz.crm.cps.business.policy.display.ladder.local.model.DisplayPolicyConfigModelVo;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayCalculateTaskRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayCalculateTaskService;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayPolicyService;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayTaskScanCodeService;
import com.biz.crm.cps.business.product.sdk.service.MaterialVoService;
import com.biz.crm.cps.external.barcode.sdk.common.enums.BarCodeTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.service.BarCodeVoService;
import com.biz.crm.cps.external.barcode.sdk.vo.BarCodeVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class DisplayCalculateTaskServiceImpl
implements DisplayCalculateTaskService {
    @Autowired
    private DisplayCalculateTaskRepository displayCalculateTaskRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired
    private BarCodeVoService barCodeVoService;
    @Autowired
    private DisplayPolicyService displayPolicyService;
    @Autowired
    private MaterialVoService materialVoService;
    @Autowired
    private DisplayTaskScanCodeService displayTaskScanCodeService;
    @Value(value="${cps.barcode.sale-standard-unit:}")
    private String saleStandardUnit;

    @Override
    @Transactional
    public void updateScanInfoByProductCodeAndBarCode(String productCode, String barCode) {
        Date now = new Date();
        LoginUserDetailsForCPS loginUser = (LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
        Validate.notNull((Object)loginUser, (String)"\u672a\u83b7\u53d6\u5230\u64cd\u4f5c\u7528\u6237\u4fe1\u606f", (Object[])new Object[0]);
        String terminalCode = loginUser.getConsumerCode();
        Validate.notBlank((CharSequence)terminalCode, (String)"\u7528\u6237\u5bf9\u5e94\u7684\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        BarCodeVo barCodeVo = this.barCodeVoService.findByBarCode(barCode);
        Validate.notNull((Object)barCodeVo, (String)"\u672a\u83b7\u53d6\u5230\u6761\u7801\u5bf9\u5e94\u7684\u914d\u7f6e\u4fe1\u606f", (Object[])new Object[0]);
        List<DisplayCalculateTask> taskList = this.displayCalculateTaskRepository.findCurrentRunningTaskByTerminalCode(terminalCode, DisplayTaskStatusNewEnum.RUNNING.getDictCode());
        if (CollectionUtils.isEmpty(taskList)) {
            return;
        }
        List list = taskList.stream().filter(a -> "0".equals(a.getBindSaleStatus())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        BigDecimal countSales = BigDecimal.ZERO;
        if (this.saleStandardUnit.equals(BarCodeTypeEnum.BOX.getKey())) {
            countSales = countSales.add(barCodeVo.getStandardUnitBoxValue());
        } else if (this.saleStandardUnit.equals(BarCodeTypeEnum.BOTTLE.getKey())) {
            countSales = countSales.add(barCodeVo.getStandardUnitBottleValue());
        }
        Set<String> displayPolicyIds = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getDisplayPolicyId())).map(DisplayCalculateTask::getDisplayPolicyId).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(displayPolicyIds)) {
            return;
        }
        List<DisplayPolicyConfigModelVo> displayPolicyConfigModelVoList = this.displayPolicyService.findDisplayPolicyConfigModelVoByPolicyIds(displayPolicyIds);
        if (CollectionUtils.isEmpty(displayPolicyConfigModelVoList)) {
            return;
        }
        Set<String> policyIdSet = this.findValidatePolicyIdSet(displayPolicyConfigModelVoList, productCode);
        if (CollectionUtils.isEmpty(policyIdSet)) {
            return;
        }
        ArrayList needUpdateList = Lists.newArrayList();
        ArrayList scanCodeList = Lists.newArrayList();
        for (DisplayCalculateTask displayCalculateTask : list) {
            if (!policyIdSet.contains(displayCalculateTask.getDisplayPolicyId())) continue;
            displayCalculateTask.setSaleActual(Optional.ofNullable(displayCalculateTask.getSaleActual()).orElse(BigDecimal.ZERO).add(countSales));
            needUpdateList.add(displayCalculateTask);
            DisplayTaskScanCode scanCode = new DisplayTaskScanCode();
            scanCode.setAmount(countSales);
            scanCode.setBusinessCode(displayCalculateTask.getBusinessCode());
            scanCode.setBarCode(barCode);
            scanCode.setProductCode(productCode);
            scanCodeList.add(scanCode);
        }
        if (!CollectionUtils.isEmpty((Collection)needUpdateList)) {
            this.displayCalculateTaskRepository.saveOrUpdateBatch(needUpdateList);
        }
        if (!CollectionUtils.isEmpty((Collection)scanCodeList)) {
            this.displayTaskScanCodeService.saveBatch(scanCodeList);
        }
    }

    @Override
    public List<DisplayCalculateTask> findByBusinessCodes(List<String> businessCodeList) {
        if (CollectionUtils.isEmpty(businessCodeList)) {
            return Lists.newLinkedList();
        }
        return this.displayCalculateTaskRepository.findByBusinessCodes(businessCodeList);
    }

    private Set<String> findValidatePolicyIdSet(List<DisplayPolicyConfigModelVo> displayPolicyConfigModelVoList, String productCode) {
        HashSet set = Sets.newHashSet();
        if (CollectionUtils.isEmpty(displayPolicyConfigModelVoList) || StringUtils.isBlank((CharSequence)productCode)) {
            return set;
        }
        Map<String, List<DisplayPolicyConfigModelVo>> map = displayPolicyConfigModelVoList.stream().collect(Collectors.groupingBy(DisplayPolicyConfigModelVo::getPolicyId));
        for (Map.Entry<String, List<DisplayPolicyConfigModelVo>> item : map.entrySet()) {
            List curList;
            List<DisplayPolicyConfigModelVo> list = item.getValue();
            if (CollectionUtils.isEmpty(list)) continue;
            String dimensionFlag = list.get(0).getDimensionFlag();
            List codes = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getSpecialCode())).map(DisplayPolicyConfigModelVo::getSpecialCode).collect(Collectors.toList());
            if (StringUtils.isBlank((CharSequence)dimensionFlag) || CollectionUtils.isEmpty(codes) || CollectionUtils.isEmpty((Collection)(curList = this.materialVoService.findMaterialCodeByDimensionCodesAndDimensionType(codes, dimensionFlag))) || !curList.contains(productCode)) continue;
            set.add(item.getKey());
        }
        return set;
    }
}

