/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.display.ladder.local.service.internal;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.bisiness.policy.display.sdk.dto.DisplayPolicyDto;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementPolicyDto;
import com.biz.crm.cps.business.agreement.sdk.dto.ProfitAgreementTemplatePaginationDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementLadderVoService;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementTemplateVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementLadderVo;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementTemplateVo;
import com.biz.crm.cps.business.agreement.sdk.vo.TemplateOrgRelationshipVo;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicy;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicyExpression;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicyRange;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicySaleTarget;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicyUploadRule;
import com.biz.crm.cps.business.policy.display.ladder.local.model.DisplayPolicyConfigModelVo;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayPolicyConfigurationRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayPolicyExpressionRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayPolicyRangeRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayPolicyRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayPolicySaleTargetRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayPolicyUploadRuleRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayTaskUploadDetailRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayTaskUploadRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayPolicyService;
import com.biz.crm.cps.business.policy.display.ladder.local.service.observer.DisplayPolicyMountRegisterImpl;
import com.biz.crm.cps.business.product.sdk.service.MaterialVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class DisplayPolicyServiceImpl
implements DisplayPolicyService {
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired
    private DisplayPolicyRepository policyRepository;
    @Autowired
    private DisplayPolicyConfigurationRepository configurationRepository;
    @Autowired
    private DisplayPolicyRangeRepository rangeRepository;
    @Autowired
    private DisplayPolicyExpressionRepository expressionRepository;
    @Autowired
    private DisplayPolicySaleTargetRepository saleTargetRepository;
    @Autowired
    private DisplayPolicyUploadRuleRepository uploadRuleRepository;
    @Autowired
    private DisplayTaskUploadRepository displayTaskUploadRepository;
    @Autowired
    private MaterialVoService materialVoService;
    @Autowired
    private AgreementLadderVoService agreementLadderVoService;
    @Autowired
    private AgreementTemplateVoService agreementTemplateVoService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private DisplayPolicyMountRegisterImpl displayPolicyMountRegister;
    @Autowired
    private DisplayTaskUploadDetailRepository displayTaskUploadDetailRepository;

    @Override
    @Transactional
    public DisplayPolicy create(AgreementPolicyDto agreementPolicyDto) {
        if (agreementPolicyDto == null) {
            return null;
        }
        DisplayPolicy displayPolicy = (DisplayPolicy)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)agreementPolicyDto, DisplayPolicy.class, HashSet.class, ArrayList.class, new String[]{"saleTarget", "uploadRules", "displayPolicyConfigurations", "displayPolicyConfigurations.displayPolicyRanges", "displayPolicyConfigurations.displayPolicyExpressions", "displaySampleGraphs"}));
        return this.createFrom(displayPolicy);
    }

    @Override
    @Transactional
    public DisplayPolicy createFrom(DisplayPolicy displayPolicy) {
        this.createValidation(displayPolicy);
        Date now = new Date();
        displayPolicy.setCreateTime(now);
        displayPolicy.setModifyTime(now);
        displayPolicy.setCreateAccount(this.loginUserService.getLoginAccountName());
        displayPolicy.setModifyAccount(this.loginUserService.getLoginAccountName());
        displayPolicy.setUploadTimes(displayPolicy.getUploadRules().size());
        ArrayList dimensionCodes = Lists.newArrayList();
        this.policyRepository.save((Object)displayPolicy);
        DisplayPolicySaleTarget saleTarget = displayPolicy.getSaleTarget();
        saleTarget.setDisplayPolicyId(displayPolicy.getId());
        this.saleTargetRepository.save((Object)displayPolicy.getSaleTarget());
        if (!CollectionUtils.isEmpty(displayPolicy.getDisplaySampleGraphs())) {
            displayPolicy.getDisplaySampleGraphs().forEach(sampleGraph -> sampleGraph.setBusinessCode(displayPolicy.getId()));
            this.displayTaskUploadDetailRepository.saveBatch(displayPolicy.getDisplaySampleGraphs());
        }
        displayPolicy.getUploadRules().forEach(displayPolicyUploadRule -> displayPolicyUploadRule.setDisplayPolicyId(displayPolicy.getId()));
        this.uploadRuleRepository.saveBatch(displayPolicy.getUploadRules());
        displayPolicy.getDisplayPolicyConfigurations().forEach(policyConfiguration -> {
            policyConfiguration.setDisplayPolicyId(displayPolicy.getId());
            AgreementLadderVo agreementLadderVo = this.agreementLadderVoService.findByLadderCode(policyConfiguration.getAgreementLadderCode());
            if (ObjectUtils.allNotNull((Object[])new Object[]{agreementLadderVo})) {
                policyConfiguration.setDisplayNumber(agreementLadderVo.getDisplayNumber());
            }
            this.configurationRepository.save(policyConfiguration);
            policyConfiguration.getDisplayPolicyRanges().forEach(displayPolicyRange -> {
                dimensionCodes.add(displayPolicyRange.getSpecialCode());
                displayPolicyRange.setConfigurationId(policyConfiguration.getId());
            });
            this.rangeRepository.saveBatch(policyConfiguration.getDisplayPolicyRanges());
            policyConfiguration.getDisplayPolicyExpressions().forEach(policyExpression -> policyExpression.setConfigurationId(policyConfiguration.getId()));
            this.expressionRepository.saveBatch(policyConfiguration.getDisplayPolicyExpressions());
        });
        CompletableFuture.runAsync(() -> this.materialVoService.sync(dimensionCodes, displayPolicy.getDimensionFlag()));
        return displayPolicy;
    }

    @Override
    public DisplayPolicy findByTemplateCode(String templateCode) {
        return this.policyRepository.findDetailByTemplateCode(templateCode);
    }

    private void createValidation(DisplayPolicy displayPolicy) {
        Validate.notNull((Object)((Object)displayPolicy), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u9648\u5217\u653f\u7b56\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        displayPolicy.setId(null);
        if (StringUtils.isBlank((CharSequence)displayPolicy.getTenantCode())) {
            displayPolicy.setTenantCode(TenantUtils.getTenantCode());
        }
        Set<DisplayPolicyUploadRule> uploadRules = displayPolicy.getUploadRules();
        Validate.isTrue((!CollectionUtils.isEmpty(displayPolicy.getDisplaySampleGraphs()) ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u9648\u5217\u793a\u4f8b\u56fe\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(displayPolicy.getDisplayPolicyConfigurations()) ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u653f\u7b56\u914d\u7f6e\u884c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(uploadRules) ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u9648\u5217\u7167\u4e0a\u4f20\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)displayPolicy.getDimensionFlag(), (String)"\u4ea7\u54c1\u7ef4\u5ea6\u6807\u8bb0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)displayPolicy.getDimensionName(), (String)"\u4ea7\u54c1\u7ef4\u5ea6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        displayPolicy.getDisplayPolicyConfigurations().forEach(displayPolicyConfiguration -> {
            if (!displayPolicy.getDimensionFlag().equals("DIMENSION_ALL")) {
                Validate.notBlank((CharSequence)displayPolicyConfiguration.getAgreementLadderCode(), (String)"\u9636\u68af\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.isTrue((!CollectionUtils.isEmpty(displayPolicyConfiguration.getDisplayPolicyRanges()) ? 1 : 0) != 0, (String)"\u653f\u7b56\u5173\u8054\u4ea7\u54c1\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                displayPolicyConfiguration.getDisplayPolicyRanges().forEach(this::displayRangeValidation);
            }
            Validate.isTrue((!CollectionUtils.isEmpty(displayPolicyConfiguration.getDisplayPolicyExpressions()) ? 1 : 0) != 0, (String)"\u653f\u7b56\u5173\u8054\u5206\u5229\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            displayPolicyConfiguration.getDisplayPolicyExpressions().forEach(this::displayPolicyExpressionValidation);
        });
        uploadRules.forEach(this::displayUploadRulesValidation);
        if (uploadRules.size() == 1) {
            return;
        }
        List<DisplayPolicyUploadRule> displayPolicyUploadRuleList = new ArrayList<DisplayPolicyUploadRule>(displayPolicy.getUploadRules());
        displayPolicyUploadRuleList = displayPolicyUploadRuleList.stream().sorted(Comparator.comparing(DisplayPolicyUploadRule::getOrderNum)).collect(Collectors.toList());
        for (int i = 1; i < displayPolicyUploadRuleList.size(); ++i) {
            Validate.isTrue((displayPolicyUploadRuleList.get(i).getStartDay() > displayPolicyUploadRuleList.get(i - 1).getStartDay() ? 1 : 0) != 0, (String)"\u9648\u5217\u56fe\u7247\u540e\u7eed\u4efb\u52a1\u4e0a\u4f20\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u524d\u4e00\u4e2a\u4efb\u52a1\u5f00\u59cb\u65f6\u95f4\uff01", (Object[])new Object[0]);
            Validate.isTrue((displayPolicyUploadRuleList.get(i).getEndDay() >= displayPolicyUploadRuleList.get(i - 1).getEndDay() ? 1 : 0) != 0, (String)"\u9648\u5217\u56fe\u7247\u540e\u7eed\u4efb\u52a1\u4e0a\u4f20\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u524d\u4e00\u4e2a\u4efb\u52a1\u7ed3\u675f\u65f6\u95f4\uff01", (Object[])new Object[0]);
        }
    }

    private void displayRangeValidation(DisplayPolicyRange displayPolicyRange) {
        Validate.notNull((Object)((Object)displayPolicyRange), (String)"\u4f20\u5165\u4fe1\u606f\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        displayPolicyRange.setId(null);
        Validate.notBlank((CharSequence)displayPolicyRange.getSpecialCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4ea7\u54c1\u7ef4\u5ea6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)displayPolicyRange.getSpecialName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4ea7\u54c1\u7ef4\u5ea6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void displayPolicyExpressionValidation(DisplayPolicyExpression displayPolicyExpression) {
        Validate.notNull((Object)((Object)displayPolicyExpression), (String)"\u4f20\u5165\u4fe1\u606f\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        displayPolicyExpression.setId(null);
        Validate.notBlank((CharSequence)displayPolicyExpression.getRewardMethodFlag(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5956\u52b1\u65b9\u5f0f\u6807\u5fd7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)displayPolicyExpression.getRewardMethodName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5956\u52b1\u65b9\u5f0f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)displayPolicyExpression.getDisplayNumber(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u9648\u5217\u9762\u8fbe\u6807\u4e2a\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)displayPolicyExpression.getRewardData(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5956\u52b1\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((displayPolicyExpression.getRewardData().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u5956\u52b1\u6570\u636e\u5fc5\u987b\u5927\u4e8e0\uff01", (Object[])new Object[0]);
    }

    private void displayUploadRulesValidation(DisplayPolicyUploadRule uploadRule) {
        Validate.notNull((Object)((Object)uploadRule), (String)"\u4f20\u5165\u4fe1\u606f\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        uploadRule.setId(null);
        Validate.notNull((Object)uploadRule.getOrderNum(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u9648\u5217\u7167\u4e0a\u4f20\u89c4\u5219\u6b21\u6570\u6807\u8bb0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((uploadRule.getOrderNum() > 0 ? 1 : 0) != 0, (String)"\u9648\u5217\u7167\u4e0a\u4f20\u89c4\u5219\u6b21\u6570\u6807\u8bb0\u5fc5\u987b\u5927\u4e8e0\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)uploadRule.getStartDay(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u9648\u5217\u7167\u4e0a\u4f20\u89c4\u5219\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((uploadRule.getStartDay() > 0 && uploadRule.getStartDay() < 32 ? 1 : 0) != 0, (String)"\u9648\u5217\u7167\u4e0a\u4f20\u89c4\u5219\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e0\u4e14\u5c0f\u4e8e32\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)uploadRule.getEndDay(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u9648\u5217\u7167\u4e0a\u4f20\u89c4\u5219\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((uploadRule.getEndDay() >= uploadRule.getStartDay() && uploadRule.getEndDay() < 32 ? 1 : 0) != 0, (String)"\u9648\u5217\u7167\u4e0a\u4f20\u89c4\u5219\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u9648\u5217\u7167\u4e0a\u4f20\u89c4\u5219\u5f00\u59cb\u65f6\u95f4\u4e14\u5c0f\u4e8e32\uff01", (Object[])new Object[0]);
    }

    @Override
    public void validatePolicyScope(AgreementTemplateVo agreementTemplateVo, AgreementPolicyDto agreementPolicyDto) {
        ProfitAgreementTemplatePaginationDto templatePaginationDto = new ProfitAgreementTemplatePaginationDto();
        if (!CollectionUtils.isEmpty((Collection)agreementTemplateVo.getTemplateOrgRelationships())) {
            List orgCodes = agreementTemplateVo.getTemplateOrgRelationships().stream().map(TemplateOrgRelationshipVo::getOrgCode).collect(Collectors.toList());
            templatePaginationDto.setOrgCodes(orgCodes);
        }
        templatePaginationDto.setPolicyCode(this.displayPolicyMountRegister.getKey());
        templatePaginationDto.setEffectiveScopeStartTime(agreementTemplateVo.getEffectiveStartTime());
        templatePaginationDto.setEffectiveScopeEndTime(agreementTemplateVo.getEffectiveEndTime());
        templatePaginationDto.setStatus(EnableStatusEnum.ENABLE.getCode());
        List templateVos = this.agreementTemplateVoService.findByConditions(templatePaginationDto);
        if (CollectionUtils.isEmpty((Collection)templateVos)) {
            return;
        }
        DisplayPolicy displayPolicy = (DisplayPolicy)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)agreementPolicyDto, DisplayPolicy.class, HashSet.class, ArrayList.class, new String[]{"displayPolicyConfigurations", "displayPolicyConfigurations.displayPolicyRanges", "displayPolicyConfigurations.displayPolicyExpressions"}));
        List templateCodes = templateVos.stream().map(AgreementTemplateVo::getTemplateCode).collect(Collectors.toList());
        DisplayPolicyDto displayPolicyDto = new DisplayPolicyDto();
        displayPolicyDto.setTemplateCodes(templateCodes);
        List<DisplayPolicy> quantifyPolicies = this.policyRepository.findByConditions(displayPolicyDto);
        if (CollectionUtils.isEmpty(quantifyPolicies)) {
            return;
        }
        Map<String, Map<Boolean, List<String>>> ladderRangeMap = this.policyLadderValidation(displayPolicy);
        quantifyPolicies.forEach(policy -> {
            Map<String, Map<Boolean, List<String>>> oldLadderRangeMap = this.policyLadderValidation((DisplayPolicy)((Object)policy));
            oldLadderRangeMap.forEach((key, value) -> {
                if (ladderRangeMap.containsKey(key)) {
                    Map rangeMap = (Map)ladderRangeMap.get(key);
                    Validate.isTrue((rangeMap.containsKey(false) && value.containsKey(false) ? 1 : 0) != 0, (String)"\u591a\u4e2a\u653f\u7b56\u914d\u7f6e\u5171\u7528\u540c\u4e00\u4e2a\u534f\u8bae\u9636\u68af\u5e76\u5305\u542b\u5168\u90e8\u4ea7\u54c1\uff01", (Object[])new Object[0]);
                    ((List)value.get(false)).retainAll((Collection)rangeMap.get(false));
                    Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)((Collection)value.get(false))), (String)"\u591a\u4e2a\u653f\u7b56\u914d\u7f6e\u5171\u7528\u540c\u4e00\u4e2a\u534f\u8bae\u9636\u68af\u5e76\u51fa\u73b0\u7269\u6599\u91cd\u590d", (Object[])new Object[0]);
                }
            });
        });
    }

    @Override
    @Transactional
    public void update(AgreementPolicyDto deserialize, Boolean before) {
        if (before.booleanValue()) {
            this.policyRepository.deleteByTemplateCode(deserialize.getTemplateCode());
            this.create(deserialize);
        }
    }

    @Override
    public List<DisplayPolicyConfigModelVo> findDisplayPolicyConfigModelVoByPolicyIds(Set<String> policyIds) {
        if (CollectionUtils.isEmpty(policyIds)) {
            return Lists.newLinkedList();
        }
        return this.policyRepository.findDisplayPolicyConfigModelVoByPolicyIds(policyIds);
    }

    @Override
    public List<String> findPolicyUploadSamplePicUrlListByPolicyId(String policyId) {
        if (StringUtils.isBlank((CharSequence)policyId)) {
            return Lists.newLinkedList();
        }
        return this.policyRepository.findPolicyUploadSamplePicUrlListByPolicyId(policyId);
    }

    private List<String> policyRangeValidation(DisplayPolicy displayPolicy) {
        ArrayList materialCodes = Lists.newArrayList();
        Validate.isTrue((!CollectionUtils.isEmpty(displayPolicy.getDisplayPolicyConfigurations()) ? 1 : 0) != 0, (String)"\u9648\u5217\u653f\u7b56\u5fc5\u987b\u5305\u542b\u914d\u7f6e\uff01", (Object[])new Object[0]);
        displayPolicy.getDisplayPolicyConfigurations().forEach(configuration -> {
            Validate.isTrue((!CollectionUtils.isEmpty(configuration.getDisplayPolicyExpressions()) ? 1 : 0) != 0, (String)"\u9648\u5217\u653f\u7b56\u914d\u7f6e\u5fc5\u987b\u914d\u7f6e\u4ea7\u54c1\u7ef4\u5ea6\u8303\u56f4\uff01", (Object[])new Object[0]);
            List materialCodeList = this.materialVoService.findMaterialCodeByDimensionCodesAndDimensionType(configuration.getDisplayPolicyRanges().stream().map(DisplayPolicyRange::getSpecialCode).collect(Collectors.toList()), displayPolicy.getDimensionFlag());
            if (!CollectionUtils.isEmpty((Collection)materialCodeList)) {
                materialCodes.addAll(materialCodeList);
            }
        });
        return materialCodes;
    }

    private Map<String, Map<Boolean, List<String>>> policyLadderValidation(DisplayPolicy quantifyPolicy) {
        HashMap ladderRangeMap = Maps.newHashMap();
        quantifyPolicy.getDisplayPolicyConfigurations().forEach(quantifyConfiguration -> {
            Validate.notEmpty((CharSequence)quantifyConfiguration.getAgreementLadderCode(), (String)"\u521b\u5efa\u5305\u91cf\u653f\u7b56\u65f6\u9636\u68af\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            HashMap rangeMap = Maps.newHashMap();
            if ("DIMENSION_ALL".equals(quantifyPolicy.getDimensionFlag())) {
                rangeMap.put(true, Lists.newArrayList());
            } else {
                rangeMap.put(false, this.policyRangeValidation(quantifyPolicy));
            }
            if (ladderRangeMap.containsKey(quantifyConfiguration.getAgreementLadderCode())) {
                Map oldRangeMap = (Map)ladderRangeMap.get(quantifyConfiguration.getAgreementLadderCode());
                Validate.isTrue((oldRangeMap.containsKey(false) && rangeMap.containsKey(false) ? 1 : 0) != 0, (String)"\u591a\u4e2a\u653f\u7b56\u914d\u7f6e\u5171\u7528\u540c\u4e00\u4e2a\u534f\u8bae\u9636\u68af\u5e76\u5305\u542b\u5168\u90e8\u4ea7\u54c1\uff01", (Object[])new Object[0]);
                ArrayList oldRanges = Lists.newArrayList();
                oldRanges.addAll((Collection)oldRangeMap.get(false));
                oldRanges.retainAll((Collection)rangeMap.get(false));
                Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)oldRanges), (String)"\u591a\u4e2a\u653f\u7b56\u914d\u7f6e\u5171\u7528\u540c\u4e00\u4e2a\u534f\u8bae\u9636\u68af\u5e76\u51fa\u73b0\u7269\u6599\u91cd\u590d", (Object[])new Object[0]);
                ((List)rangeMap.get(false)).addAll((Collection)oldRangeMap.get(false));
            }
            ladderRangeMap.put(quantifyConfiguration.getAgreementLadderCode(), rangeMap);
        });
        return ladderRangeMap;
    }
}

