/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.display.ladder.local.service.internal;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.DisplayTaskAuditStatusNewEnum;
import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.DisplayTaskUploadAuditTypeEnum;
import com.biz.crm.cps.bisiness.policy.display.sdk.dto.DisplayTaskUploadHumanAuditDto;
import com.biz.crm.cps.bisiness.policy.display.sdk.vo.DisplayTaskAuditDetailVo;
import com.biz.crm.cps.bisiness.policy.display.sdk.vo.DisplayTaskAuditItemVo;
import com.biz.crm.cps.bisiness.policy.display.sdk.vo.DisplayTaskAuditVo;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTask;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTaskUpload;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTaskUploadAudit;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTaskUploadDetail;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayTaskRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayTaskUploadDetailRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayTaskUploadRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayPolicyService;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayTaskAuditVoService;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayTaskUploadAuditService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class DisplayTaskAuditVoServiceImpl
implements DisplayTaskAuditVoService {
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private DisplayTaskRepository displayTaskRepository;
    @Autowired
    private DisplayPolicyService displayPolicyService;
    @Autowired
    private DisplayTaskUploadRepository displayTaskUploadRepository;
    @Autowired
    private DisplayTaskUploadDetailRepository displayTaskUploadDetailRepository;
    @Autowired
    private DisplayTaskUploadAuditService displayTaskUploadAuditService;

    @Override
    public DisplayTaskAuditVo findTaskAuditByBusinessCode(String businessCode) {
        List<DisplayTaskUploadAudit> list;
        DisplayTask task = this.displayTaskRepository.findByBusinessCode(businessCode);
        if (Objects.isNull((Object)task)) {
            return null;
        }
        DisplayTaskAuditVo vo = new DisplayTaskAuditVo();
        String displayPolicyId = task.getDisplayPolicyId();
        if (StringUtils.isNotBlank((CharSequence)displayPolicyId)) {
            vo.setSamplePicUrlList(this.displayPolicyService.findPolicyUploadSamplePicUrlListByPolicyId(displayPolicyId));
        }
        List<DisplayTaskUpload> taskUploadList = this.displayTaskUploadRepository.findByBusinessCode(businessCode);
        List<DisplayTaskUploadDetail> detailList = this.displayTaskUploadDetailRepository.findByBusinessCode(businessCode);
        if (CollectionUtils.isEmpty(taskUploadList)) {
            return vo;
        }
        Map<Object, Object> mapPic = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(detailList)) {
            mapPic = detailList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getUploadId()) && StringUtils.isNotBlank((CharSequence)a.getPictureUrl())).collect(Collectors.groupingBy(DisplayTaskUploadDetail::getUploadId, Collectors.mapping(DisplayTaskUploadDetail::getPictureUrl, Collectors.toList())));
        }
        Map<Object, Object> mapAudit = Maps.newHashMap();
        List<String> uploadIds = taskUploadList.stream().map(UuidEntity::getId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(uploadIds) && !CollectionUtils.isEmpty(list = this.displayTaskUploadAuditService.findByDisplayTaskUploadIds(uploadIds))) {
            mapAudit = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getDisplayTaskUploadId())).collect(Collectors.groupingBy(DisplayTaskUploadAudit::getDisplayTaskUploadId));
        }
        ArrayList itemVoList = Lists.newArrayList();
        for (DisplayTaskUpload item : taskUploadList) {
            DisplayTaskAuditItemVo cur = new DisplayTaskAuditItemVo();
            cur.setDisplayTaskUploadId(item.getId());
            cur.setUploadPicUrlList((List)mapPic.get(item.getId()));
            List auditList = (List)mapAudit.get(item.getId());
            if (!CollectionUtils.isEmpty((Collection)auditList)) {
                ArrayList auditDetailVoList = Lists.newArrayList();
                for (DisplayTaskUploadAudit sub : auditList) {
                    DisplayTaskAuditDetailVo detailVo = new DisplayTaskAuditDetailVo();
                    detailVo.setAuditType(sub.getDisplayAuditType());
                    detailVo.setAuditStatus(sub.getAuditStatus());
                    detailVo.setRemark(sub.getRemark());
                    detailVo.setAuditTime(sub.getCreateTime());
                    detailVo.setUploadTime(item.getCreateTime());
                    auditDetailVoList.add(detailVo);
                }
                cur.setAuditDetailVoList((List)auditDetailVoList);
            }
            itemVoList.add(cur);
        }
        vo.setItemVoList((List)itemVoList);
        return vo;
    }

    @Override
    @Transactional
    public void auditByHuman(DisplayTaskUploadHumanAuditDto dto) {
        LoginUserDetailsForCPS loginUser = (LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
        Validate.notNull((Object)loginUser, (String)"\u672a\u83b7\u53d6\u5230\u64cd\u4f5c\u4eba\u4fe1\u606f", (Object[])new Object[0]);
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDisplayTaskUploadId(), (String)"\u9648\u5217\u4efb\u52a1\u56fe\u7247\u4e0a\u4f20\u8bb0\u5f55id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getAuditStatus(), (String)"\u5ba1\u6838\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Boolean f = DisplayTaskAuditStatusNewEnum.AUDIT_PASS.getDictCode().equals(dto.getAuditStatus()) || DisplayTaskAuditStatusNewEnum.AUDIT_REJECT.getDictCode().equals(dto.getAuditStatus());
        Validate.isTrue((boolean)f, (String)"\u4eba\u5de5\u5ba1\u6838\u72b6\u6001\u5f02\u5e38", (Object[])new Object[0]);
        if (DisplayTaskAuditStatusNewEnum.AUDIT_REJECT.getDictCode().equals(dto.getAuditStatus())) {
            Validate.notBlank((CharSequence)dto.getRemark(), (String)"\u5907\u6ce8\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        DisplayTaskUploadAudit audit = new DisplayTaskUploadAudit();
        audit.setCreateAccount(loginUser.getAccount());
        audit.setCreateTime(new Date());
        audit.setAuditStatus(dto.getAuditStatus());
        audit.setDisplayAuditType(DisplayTaskUploadAuditTypeEnum.HUMAN.getDictCode());
        audit.setRemark(dto.getRemark());
        audit.setDisplayTaskUploadId(dto.getDisplayTaskUploadId());
        DisplayTaskUpload taskUpload = this.displayTaskUploadRepository.findById(dto.getDisplayTaskUploadId());
        Validate.notNull((Object)((Object)taskUpload), (String)"\u56fe\u7247\u4e0a\u4f20\u8bb0\u5f55\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        DisplayTask task = this.displayTaskRepository.findByBusinessCode(taskUpload.getBusinessCode());
        Validate.notNull((Object)((Object)task), (String)"\u5bf9\u5e94\u7684\u9648\u5217\u4efb\u52a1\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        task.setHumanAuditTime(new Date());
        task.setAuditStatus(dto.getAuditStatus());
        this.displayTaskRepository.saveOrUpdate((Object)task);
        this.displayTaskUploadAuditService.create(audit);
    }
}

