/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.display.ladder.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.AuditResultEnum;
import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.BindStatusEnum;
import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.DisplayTaskAuditStatusNewEnum;
import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.DisplayTaskStatusEnum;
import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.DisplayTaskStatusNewEnum;
import com.biz.crm.cps.bisiness.policy.display.sdk.dto.DisplayTaskDto;
import com.biz.crm.cps.bisiness.policy.display.sdk.dto.DisplayTaskUploadInfoDto;
import com.biz.crm.cps.business.agreement.sdk.common.enums.AgreementStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.common.enums.AutoSignEnum;
import com.biz.crm.cps.business.agreement.sdk.common.enums.SignStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementDto;
import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementLadderVoService;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementLadderVo;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayCalculateTask;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayCalculateTaskRelateTask;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicy;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicyConfiguration;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicyExpression;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicyRange;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTask;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTaskDetail;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTaskExpression;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTaskUpload;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTaskUploadDetail;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayCalculateTaskRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayTaskDetailRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayTaskExpressionRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayTaskRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayTaskUploadDetailRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayTaskUploadRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayCalculateTaskRelateTaskService;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayPolicyService;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayTaskService;
import com.biz.crm.cps.business.policy.display.ladder.local.service.builder.DisplayCalculateTaskBuilder;
import com.biz.crm.cps.business.policy.display.ladder.local.service.builder.DisplayTaskDefaultBuilder;
import com.biz.crm.cps.business.policy.display.ladder.local.service.observer.DisplayPolicyMountRegisterImpl;
import com.biz.crm.cps.business.policy.display.ladder.local.service.strategy.AIDisplayAuditStrategy;
import com.biz.crm.cps.business.policy.display.ladder.local.utils.DisplaySchedulerUtils;
import com.biz.crm.cps.business.policy.sdk.dto.PolicyRewardConditionDto;
import com.biz.crm.cps.business.policy.sdk.service.observer.PolicyRewardServiceObserver;
import com.biz.crm.cps.business.product.sdk.service.MaterialVoService;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeExceptionEnum;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordPageDto;
import com.biz.crm.cps.external.barcode.sdk.service.ScanCodeRecordVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.bizunited.nebula.task.service.DynamicTaskSchedulerVoService;
import com.bizunited.nebula.task.vo.DynamicTaskSchedulerVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="displayTaskServiceImpl")
public class DisplayTaskServiceImpl
implements DisplayTaskService {
    @Autowired
    private AgreementVoService agreementVoService;
    @Autowired
    private DisplayPolicyService displayPolicyService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    private DisplayTaskRepository displayTaskRepository;
    @Autowired
    private ScanCodeRecordVoService scanCodeRecordVoService;
    @Autowired
    private MaterialVoService materialVoService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private List<PolicyRewardServiceObserver> policyRewardServiceObservers;
    @Autowired
    private DisplayTaskDetailRepository displayTaskDetailRepository;
    @Autowired
    private DynamicTaskSchedulerVoService dynamicTaskSchedulerVoService;
    @Autowired
    private DisplayTaskUploadDetailRepository displayTaskUploadDetailRepository;
    @Autowired
    private DisplayPolicyMountRegisterImpl displayPolicyMountRegister;
    @Autowired
    private List<DisplayCalculateTaskBuilder> displayCalculateTaskBuilders;
    @Autowired
    private AgreementLadderVoService agreementLadderVoService;
    @Autowired
    private DisplayCalculateTaskRepository displayCalculateTaskRepository;
    @Autowired
    private DisplayTaskExpressionRepository displayTaskExpressionRepository;
    @Autowired
    private DisplayTaskUploadRepository displayTaskUploadRepository;
    @Autowired
    private List<AIDisplayAuditStrategy> aiDisplayAuditStrategies;
    @Autowired
    private DisplayCalculateTaskRelateTaskService displayCalculateTaskRelateTaskService;

    @Override
    @Transactional
    public List<DisplayTask> create(String agreementId) {
        Validate.notBlank((CharSequence)agreementId, (String)"\u534f\u8baeid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        LoginUserAgreementDto loginUserAgreementDto = new LoginUserAgreementDto();
        loginUserAgreementDto.setAgreementCode(agreementId);
        AgreementDto agreementDto = new AgreementDto();
        agreementDto.setAgreementCode(agreementId);
        Page agreementVo = this.agreementVoService.findByConditions((Pageable)PageRequest.of((int)0, (int)50), agreementDto);
        if (agreementVo != null && !CollectionUtils.isEmpty((Collection)agreementVo.getRecords())) {
            return this.create((AgreementVo)agreementVo.getRecords().get(0));
        }
        return Lists.newArrayList();
    }

    @Override
    @Transactional
    public List<DisplayTask> create(AgreementVo agreementVo) {
        Validate.notNull((Object)agreementVo, (String)"\u534f\u8bae\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DisplayPolicy displayPolicy = this.displayPolicyService.findByTemplateCode(agreementVo.getTemplateCode());
        Validate.notNull((Object)((Object)displayPolicy), (String)("\u534f\u8bae\u6a21\u677f\u7f16\u7801" + agreementVo.getAgreementCode() + "\u672a\u627e\u5230\u5bf9\u5e94\u7684\u9648\u5217\u653f\u7b56\uff01"), (Object[])new Object[0]);
        DisplayTaskDefaultBuilder displayTaskBuilder = new DisplayTaskDefaultBuilder();
        List<DisplayTask> taskList = displayTaskBuilder.handleAssemblyDisplayTask(agreementVo, displayPolicy);
        if (!CollectionUtils.isEmpty(taskList)) {
            List businessCodes = this.generateCodeService.generateCode("display-task-code", taskList.size());
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)businessCodes) && businessCodes.size() == taskList.size() ? 1 : 0) != 0, (String)"\u751f\u6210\u4e1a\u52a1\u5355\u53f7\u5f02\u5e38", (Object[])new Object[0]);
            String tenantCode = TenantUtils.getTenantCode();
            for (int i = 0; i < taskList.size(); ++i) {
                DisplayTask task2 = taskList.get(i);
                task2.setBusinessCode((String)businessCodes.get(i));
                task2.setDisplayPolicyId(displayPolicy.getId());
                task2.setAgreementId(agreementVo.getAgreementCode());
                task2.setAgreementName(agreementVo.getAgreementName());
                task2.setTemplateId(agreementVo.getTemplateCode());
                task2.setTemplateName(agreementVo.getBelongTemplate());
                task2.setTerminalCode(agreementVo.getTerminalCode());
                task2.setTerminalName(agreementVo.getRelationTerminal());
                task2.setUploadPictureNumber(0);
                task2.setDisplayType(displayPolicy.getDisplayType());
                task2.setTenantCode(tenantCode);
            }
        }
        this.displayTaskRepository.saveBatch(taskList);
        ArrayList quantifyTasks = Lists.newArrayList();
        displayPolicy.getDisplayPolicyConfigurations().forEach(configuration -> {
            List<DisplayCalculateTask> quantifyTaskList = this.buildDisplayCalculateTask(agreementVo, (DisplayPolicyConfiguration)((Object)configuration), displayPolicy);
            if (!CollectionUtils.isEmpty(quantifyTaskList)) {
                quantifyTasks.addAll(quantifyTaskList);
            }
        });
        this.bindCalculateTaskRelateTask(quantifyTasks, taskList);
        this.displayCalculateTaskRepository.saveBatch(quantifyTasks);
        quantifyTasks.forEach(quantifyTask -> this.displayTaskExpressionRepository.saveBatch(quantifyTask.getDisplayTaskExpressionList()));
        quantifyTasks.forEach(task -> {
            DynamicTaskSchedulerVo taskSchedulerVo = this.dynamicTaskSchedulerVoService.createIgnorePrefix(task.getBusinessCode(), "displayTaskServiceImpl", "handleSettlementTask", DisplaySchedulerUtils.getSchedulerCron(task.getTaskType()), agreementVo.getEffectiveEndTime(), task.getTaskName(), new Object[]{task.getBusinessCode()});
            this.dynamicTaskSchedulerVoService.start(new String[]{taskSchedulerVo.getTaskCode()});
        });
        return taskList;
    }

    @Override
    @DynamicTaskService(cornExpression="0 0 0 * * ?", taskDesc="\u542f\u52a8/\u5173\u95ed\u9648\u5217\u4efb\u52a1")
    @Transactional
    public void handleDisplayTask() {
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        int nowDay = calendar.get(5);
        Date startTime = DateUtils.ceiling((Date)DateUtils.setDays((Date)now, (int)(nowDay - 1)), (int)5);
        this.startDisplayTaskBatch(startTime);
        Date endTime = DateUtils.addSeconds((Date)startTime, (int)-1);
        this.closeDisplayTaskBatch(endTime);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void handleSettlementTask(String businessCode) {
        DisplayCalculateTask displayCalculateTask = this.displayCalculateTaskRepository.findByBusinessCode(businessCode);
        Validate.notNull((Object)((Object)displayCalculateTask), (String)("\u4e1a\u52a1\u5355\u53f7\uff1a" + businessCode + "\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u9648\u5217\u4efb\u52a1\uff01"), (Object[])new Object[0]);
        Validate.isTrue((boolean)DisplayTaskStatusNewEnum.RUNNING.getDictCode().equals(displayCalculateTask.getTaskStatus()), (String)"\u53ea\u6709\u5f85\u6267\u884c\u7684\u4efb\u52a1\u53ef\u4ee5\u8fdb\u884c\u7ed3\u7b97\uff01", (Object[])new Object[0]);
        DisplayPolicy displayPolicy = this.displayPolicyService.findByTemplateCode(displayCalculateTask.getTemplateId());
        Validate.notNull((Object)((Object)displayPolicy), (String)("\u4e1a\u52a1\u5355\u53f7\uff1a" + businessCode + "\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u9648\u5217\u653f\u7b56\uff01"), (Object[])new Object[0]);
        LoginUserAgreementDto loginUserAgreementDto = new LoginUserAgreementDto();
        loginUserAgreementDto.setSignStatus(SignStatusEnum.SIGNED.getCode());
        loginUserAgreementDto.setAgreementStatus(AgreementStatusEnum.EXECUTING.getCode());
        loginUserAgreementDto.setAgreementCode(displayCalculateTask.getAgreementId());
        List agreementVos = this.agreementVoService.findByConditions(loginUserAgreementDto);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)agreementVos) ? 1 : 0) != 0, (String)("\u4e1a\u52a1\u5355\u53f7\uff1a" + businessCode + "\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u5df2\u751f\u6548\u534f\u8bae\uff01"), (Object[])new Object[0]);
        List<DisplayTaskDetail> displayTaskDetails = this.buildTaskDetail(displayPolicy, displayCalculateTask);
        this.sendToCost(displayCalculateTask, displayTaskDetails);
        this.updateDisplayTask(displayCalculateTask, displayTaskDetails);
        if (!CollectionUtils.isEmpty(displayTaskDetails)) {
            this.displayTaskDetailRepository.saveBatch(displayTaskDetails);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateTaskStatus(DisplayTaskDto displayTaskDto) {
        Validate.notNull((Object)displayTaskDto, (String)"\u63d0\u4ea4\u4efb\u52a1\u5ba1\u6838\u65f6\uff0c\u4f20\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)displayTaskDto.getBusinessCode());
        Validate.notBlank((CharSequence)displayTaskDto.getFinalAuditResult());
        DisplayTask displayTask = this.displayTaskRepository.findByBusinessCode(displayTaskDto.getBusinessCode());
        Validate.notNull((Object)((Object)displayTask), (String)"\u8be5\u4efb\u52a1\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        displayTask.setFinalAuditResult(displayTaskDto.getFinalAuditResult());
        displayTask.setRemark(displayTaskDto.getRemark());
        if (AuditResultEnum.QUALIFIED.getDictCode().equals(displayTask.getFinalAuditResult())) {
            displayTask.setTaskStatus(DisplayTaskStatusEnum.STATUS_PASS.getDictCode());
        } else {
            displayTask.setTaskStatus(DisplayTaskStatusEnum.STATUS_NOT_PASS.getDictCode());
        }
        this.displayTaskRepository.updateById((Object)displayTask);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void handleSubmitDisplayTask(DisplayTaskUploadInfoDto displayTaskUploadInfoDto) {
        Validate.notNull((Object)displayTaskUploadInfoDto, (String)"\u4f20\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)displayTaskUploadInfoDto.getBusinessCode(), (String)"\u4f20\u5165\u4e1a\u52a1\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)displayTaskUploadInfoDto.getDisplayTaskUploads()) ? 1 : 0) != 0, (String)"\u4e0a\u4f20\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        DisplayTask displayTask = this.displayTaskRepository.findByBusinessCode(displayTaskUploadInfoDto.getBusinessCode());
        Validate.notNull((Object)((Object)displayTask), (String)"\u8be5\u4efb\u52a1\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        List<DisplayTaskUpload> displayTaskUploads = this.displayTaskUploadRepository.findByBusinessCode(displayTask.getBusinessCode());
        Validate.isTrue((displayTaskUploads.size() < 2 ? 1 : 0) != 0, (String)"\u6b64\u4efb\u52a1\u5df2\u4e0a\u4f20\u8fc72\u6b21\u56fe\u7247\uff0c\u65e0\u6cd5\u7ee7\u7eed\u4e0a\u4f20\u56fe\u7247", (Object[])new Object[0]);
        displayTask.setUploadPictureNumber(displayTaskUploads.size() + 1);
        displayTask.setRemark(displayTaskUploadInfoDto.getRemark());
        Date now = new Date();
        DisplayTaskUpload displayTaskUpload = new DisplayTaskUpload();
        displayTaskUpload.setUploadNumber(displayTask.getUploadPictureNumber());
        displayTaskUpload.setRemark(displayTask.getRemark());
        displayTaskUpload.setBusinessCode(displayTask.getBusinessCode());
        displayTaskUpload.setPictureNumber(displayTaskUploadInfoDto.getDisplayTaskUploads().size());
        displayTaskUpload.setCreateTime(now);
        this.displayTaskUploadRepository.save((Object)displayTaskUpload);
        ArrayList displayTaskUploadDetails = Lists.newArrayList();
        displayTaskUploadInfoDto.getDisplayTaskUploads().forEach(displayTaskUploadDto -> {
            DisplayTaskUploadDetail displayTaskUploadDetail = new DisplayTaskUploadDetail();
            displayTaskUploadDetail.setCreateTime(now);
            displayTaskUploadDetail.setBusinessCode(displayTask.getBusinessCode());
            displayTaskUploadDetail.setPictureUrl(displayTaskUploadDto.getPictureUrl());
            displayTaskUploadDetail.setUploadId(displayTaskUpload.getId());
            displayTaskUploadDetail.setPictureSerialNumber(displayTaskUploadDto.getPictureSerialNumber());
            displayTaskUploadDetails.add(displayTaskUploadDetail);
        });
        this.displayTaskRepository.updateById((Object)displayTask);
        this.displayTaskUploadDetailRepository.saveBatch(displayTaskUploadDetails);
        if (!CollectionUtils.isEmpty(this.aiDisplayAuditStrategies)) {
            for (AIDisplayAuditStrategy auditStrategy : this.aiDisplayAuditStrategies) {
                auditStrategy.displayAudit(displayTaskUpload);
            }
        }
    }

    @Transactional
    public void bindCalculateTaskRelateTask(List<DisplayCalculateTask> quantifyTasks, List<DisplayTask> taskList) {
        if (CollectionUtils.isEmpty(quantifyTasks) || CollectionUtils.isEmpty(taskList)) {
            return;
        }
        ArrayList list = Lists.newArrayList();
        for (DisplayCalculateTask item : quantifyTasks) {
            for (DisplayTask task : taskList) {
                if (!this.validateTimeBetween(item, task).booleanValue()) continue;
                DisplayCalculateTaskRelateTask cur = new DisplayCalculateTaskRelateTask();
                cur.setCalculateTaskCode(item.getBusinessCode());
                cur.setTaskCode(task.getBusinessCode());
                list.add(cur);
            }
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        this.displayCalculateTaskRelateTaskService.saveBatch(list);
    }

    private void startDisplayTaskBatch(Date startTime) {
        if (startTime == null) {
            return;
        }
        DisplayTaskDto displayTaskDto = new DisplayTaskDto();
        displayTaskDto.setTaskStartTime(startTime);
        displayTaskDto.setTaskStatus(DisplayTaskStatusNewEnum.DEFAULT.getDictCode());
        List<DisplayTask> displayTasks = this.displayTaskRepository.findByConditions(displayTaskDto);
        if (!CollectionUtils.isEmpty(displayTasks)) {
            displayTasks.forEach(displayTask -> displayTask.setTaskStatus(DisplayTaskStatusNewEnum.RUNNING.getDictCode()));
        }
        this.displayTaskRepository.updateBatchById(displayTasks);
        displayTaskDto.setTaskStatus(DisplayTaskStatusNewEnum.DEFAULT.getDictCode());
        List<DisplayCalculateTask> displayCalculateTasks = this.displayCalculateTaskRepository.findByConditions(displayTaskDto);
        if (!CollectionUtils.isEmpty(displayCalculateTasks)) {
            displayCalculateTasks.forEach(displayCalculateTask -> displayCalculateTask.setTaskStatus(DisplayTaskStatusNewEnum.RUNNING.getDictCode()));
        }
        this.displayCalculateTaskRepository.updateBatchById(displayCalculateTasks);
    }

    @Transactional
    public void closeDisplayTaskBatch(Date endTime) {
        if (endTime == null) {
            return;
        }
        DisplayTaskDto displayTaskDto = new DisplayTaskDto();
        displayTaskDto.setTaskEndTime(endTime);
        displayTaskDto.setAuditStatusList((List)Lists.newArrayList((Object[])new String[]{DisplayTaskAuditStatusNewEnum.DEFAULT.getDictCode(), DisplayTaskAuditStatusNewEnum.AI_DEFAULT.getDictCode(), DisplayTaskAuditStatusNewEnum.AI_REJECT.getDictCode(), DisplayTaskAuditStatusNewEnum.AUDIT_DEFAULT.getDictCode()}));
        List<DisplayTask> displayTasks = this.displayTaskRepository.findByConditions(displayTaskDto);
        if (CollectionUtils.isEmpty(displayTasks)) {
            return;
        }
        for (DisplayTask item : displayTasks) {
            if (DisplayTaskAuditStatusNewEnum.DEFAULT.getDictCode().equals(item.getAuditStatus()) || DisplayTaskAuditStatusNewEnum.AI_DEFAULT.getDictCode().equals(item.getAuditStatus())) {
                item.setAuditStatus(DisplayTaskAuditStatusNewEnum.NO_SUBMIT.getDictCode());
                item.setTaskStatus(DisplayTaskStatusNewEnum.FAIL.getDictCode());
                continue;
            }
            if (!DisplayTaskAuditStatusNewEnum.AUDIT_DEFAULT.getDictCode().equals(item.getAuditStatus()) && !DisplayTaskAuditStatusNewEnum.AI_REJECT.getDictCode().equals(item.getAuditStatus())) continue;
            item.setAuditStatus(DisplayTaskAuditStatusNewEnum.DEFAULT_PASS.getDictCode());
            item.setTaskStatus(DisplayTaskStatusNewEnum.SUCCESS.getDictCode());
        }
        this.displayTaskRepository.updateBatchById(displayTasks);
    }

    private List<DisplayTaskDetail> buildTaskDetail(DisplayPolicy displayPolicy, DisplayCalculateTask displayCalculateTask) {
        ArrayList displayTaskDetails = Lists.newArrayList();
        int allTaskNumber = this.displayTaskRepository.countByTaskTimeAndStatus(displayCalculateTask.getAgreementId(), displayCalculateTask.getTaskStartTime(), displayCalculateTask.getTaskEndTime(), null);
        int passTaskNumber = this.displayTaskRepository.countByTaskTimeAndStatus(displayCalculateTask.getAgreementId(), displayCalculateTask.getTaskStartTime(), displayCalculateTask.getTaskEndTime(), DisplayTaskStatusNewEnum.SUCCESS.getDictCode());
        BigDecimal reachRate = allTaskNumber == 0 ? BigDecimal.ZERO : new BigDecimal(passTaskNumber).divide(new BigDecimal(allTaskNumber), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
        displayPolicy.getDisplayPolicyConfigurations().forEach(configuration -> {
            if (!displayCalculateTask.getDisplayPolicyConfigurationId().equals(configuration.getId())) {
                return;
            }
            BigDecimal scanCount = BigDecimal.ZERO;
            if (BindStatusEnum.YES.getDictCode().equals(displayPolicy.getBindSaleStatus())) {
                ScanCodeRecordPageDto scanCodeRecordPageDto = new ScanCodeRecordPageDto();
                scanCodeRecordPageDto.setCreateTimeStart(displayCalculateTask.getTaskStartTime());
                scanCodeRecordPageDto.setCreateTimeEnd(displayCalculateTask.getTaskEndTime());
                scanCodeRecordPageDto.setScanParticipatorCode(displayCalculateTask.getTerminalCode());
                scanCodeRecordPageDto.setScanCodeException(ScanCodeExceptionEnum.NO.getCode());
                if ("DIMENSION_ALL".equals(displayPolicy.getDimensionFlag())) {
                    scanCodeRecordPageDto.setProductCodes((List)Lists.newArrayList());
                    scanCount = this.scanCodeRecordVoService.countSalesByScanCodeRecordPageDto(scanCodeRecordPageDto);
                } else {
                    List dimensionCodes = configuration.getDisplayPolicyRanges().stream().map(DisplayPolicyRange::getSpecialCode).collect(Collectors.toList());
                    List materialCodes = this.materialVoService.findMaterialCodeByDimensionCodesAndDimensionType(dimensionCodes, displayPolicy.getDimensionFlag());
                    if (!CollectionUtils.isEmpty((Collection)materialCodes)) {
                        scanCodeRecordPageDto.setProductCodes(materialCodes);
                        scanCount = this.scanCodeRecordVoService.countSalesByScanCodeRecordPageDto(scanCodeRecordPageDto);
                    }
                }
                if (scanCount.compareTo(displayCalculateTask.getSaleTarget()) < 0) {
                    return;
                }
            }
            if (configuration.getOnlyHighestLevel().equals(AutoSignEnum.YES.getCode())) {
                displayTaskDetails.addAll(this.calculateWithOnlyHighestLevel(displayCalculateTask, scanCount, reachRate));
            } else {
                displayTaskDetails.addAll(this.calculateWithAllLevel(displayCalculateTask, scanCount, reachRate));
            }
        });
        return displayTaskDetails;
    }

    private void sendToCost(DisplayCalculateTask displayTask, List<DisplayTaskDetail> displayTaskDetails) {
        if (CollectionUtils.isEmpty(displayTaskDetails)) {
            return;
        }
        ArrayList policyRewardConditionDtos = Lists.newArrayList();
        displayTaskDetails.forEach(detail -> {
            if (AutoSignEnum.YES.getCode().equals(detail.getProfitStatus())) {
                PolicyRewardConditionDto policyRewardConditionDto = new PolicyRewardConditionDto();
                policyRewardConditionDto.setPolicyName(this.displayPolicyMountRegister.getName());
                policyRewardConditionDto.setActualParticipatorFlag(ParticipatorTypeEnum.TERMINAL.getDictCode());
                policyRewardConditionDto.setActualParticipatorCode(displayTask.getTerminalCode());
                policyRewardConditionDto.setParticipatorFlag(ParticipatorTypeEnum.TERMINAL.getDictCode());
                policyRewardConditionDto.setParticipatorName(ParticipatorTypeEnum.TERMINAL.getValue());
                policyRewardConditionDto.setTemplateCode(displayTask.getTemplateId());
                policyRewardConditionDto.setRewardMethodFlag(detail.getRewardMethodFlag());
                policyRewardConditionDto.setRewardMethodName(detail.getRewardMethodName());
                policyRewardConditionDto.setAwardConditionFlag(detail.getAwardConditionFlag());
                policyRewardConditionDto.setAwardConditionName(detail.getAwardConditionName());
                policyRewardConditionDto.setRewardData(detail.getRewardData().toString());
                policyRewardConditionDto.setTriggerAction(this.displayPolicyMountRegister.getName());
                policyRewardConditionDto.setTriggerObject(displayTask.getBusinessCode());
                policyRewardConditionDto.setAgreementCode(displayTask.getAgreementId());
                policyRewardConditionDto.setRebateType("\u9648\u5217\u653f\u7b56\u5206\u5229");
                policyRewardConditionDtos.add(policyRewardConditionDto);
            }
        });
        if (!CollectionUtils.isEmpty((Collection)policyRewardConditionDtos) && !CollectionUtils.isEmpty(this.policyRewardServiceObservers)) {
            this.policyRewardServiceObservers.forEach(policyRewardServiceObserver -> policyRewardServiceObserver.createRewardRecord(policyRewardConditionDtos));
        }
    }

    @Transactional
    public void updateDisplayTask(DisplayCalculateTask displayTask, List<DisplayTaskDetail> displayTaskDetails) {
        Optional<DisplayTaskDetail> first;
        if (Objects.isNull((Object)displayTask)) {
            return;
        }
        displayTask.setTaskStatus(DisplayTaskStatusNewEnum.FAIL.getDictCode());
        if (!CollectionUtils.isEmpty(displayTaskDetails) && (first = displayTaskDetails.stream().filter(a -> "Y".equals(a.getProfitStatus())).findFirst()).isPresent()) {
            displayTask.setTaskStatus(DisplayTaskStatusNewEnum.SUCCESS.getDictCode());
        }
        this.displayCalculateTaskRepository.updateById((Object)displayTask);
    }

    private DisplayCalculateTaskBuilder findBuilderByCalculateCycle(String calculateCycle) {
        DisplayCalculateTaskBuilder displayCalculateTaskBuilder = null;
        for (DisplayCalculateTaskBuilder t : this.displayCalculateTaskBuilders) {
            if (!t.quantifyTaskCycle().equals(calculateCycle)) continue;
            displayCalculateTaskBuilder = t;
            break;
        }
        return displayCalculateTaskBuilder;
    }

    private List<DisplayCalculateTask> buildDisplayCalculateTask(AgreementVo agreementVo, DisplayPolicyConfiguration configuration, DisplayPolicy displayPolicy) {
        ArrayList displayCalculateTasks = Lists.newArrayList();
        Map<String, List<DisplayPolicyExpression>> displayExpressionMap = this.convertMapByCalculateCycle(configuration);
        if (displayExpressionMap.size() == 0) {
            return displayCalculateTasks;
        }
        AgreementLadderVo agreementLadderVo = this.agreementLadderVoService.findByLadderCode(configuration.getAgreementLadderCode());
        if (Objects.isNull(agreementLadderVo)) {
            return displayCalculateTasks;
        }
        displayExpressionMap.forEach((key, value) -> {
            DisplayCalculateTaskBuilder taskBuilder = this.findBuilderByCalculateCycle((String)key);
            if (Objects.isNull(taskBuilder)) {
                return;
            }
            List<DisplayCalculateTask> quantifyTasks = taskBuilder.handleAssemblyDisplayCalculateTask(agreementVo, displayPolicy);
            if (CollectionUtils.isEmpty(quantifyTasks)) {
                return;
            }
            List businessCodes = this.generateCodeService.generateCode("display-task-code", quantifyTasks.size());
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)businessCodes) && businessCodes.size() == quantifyTasks.size() ? 1 : 0) != 0, (String)"\u751f\u6210\u4e1a\u52a1\u5355\u53f7\u5f02\u5e38", (Object[])new Object[0]);
            for (int i = 0; i < quantifyTasks.size(); ++i) {
                DisplayCalculateTask task = quantifyTasks.get(i);
                task.setBusinessCode((String)businessCodes.get(i));
                task.setDisplayPolicyId(configuration.getDisplayPolicyId());
                task.setTaskType((String)key);
                task.setAgreementId(agreementVo.getAgreementCode());
                task.setAgreementName(agreementVo.getAgreementName());
                task.setTemplateId(agreementVo.getTemplateCode());
                task.setTemplateName(agreementVo.getBelongTemplate());
                task.setTerminalCode(agreementVo.getTerminalCode());
                task.setTerminalName(agreementVo.getRelationTerminal());
                task.setTenantCode(TenantUtils.getTenantCode());
                task.setBindSaleStatus(displayPolicy.getBindSaleStatus());
                task.setDisplayPolicyConfigurationId(configuration.getId());
                task.setDisplayTaskExpressionList((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)value, DisplayPolicyExpression.class, DisplayTaskExpression.class, HashSet.class, ArrayList.class, new String[0]));
                task.getDisplayTaskExpressionList().forEach(quantifyExpress -> {
                    quantifyExpress.setBusinessCode(task.getBusinessCode());
                    quantifyExpress.setId(null);
                });
                task.setDisplayType(displayPolicy.getDisplayType());
                task.setDisplayFinishTimes(BigDecimal.ZERO);
                task.setDisplayFinishRate(BigDecimal.ZERO);
                task.setSaleActual(BigDecimal.ZERO);
                task.setScanRate(BigDecimal.ZERO);
                task.setShareProfitStatus("0");
                displayCalculateTasks.add(task);
            }
        });
        return displayCalculateTasks;
    }

    private Map<String, List<DisplayPolicyExpression>> convertMapByCalculateCycle(DisplayPolicyConfiguration displayPolicyConfiguration) {
        HashMap displayExpressionMap = Maps.newHashMap();
        displayPolicyConfiguration.getDisplayPolicyExpressions().forEach(displayPolicyExpression -> {
            List expressions = (List)displayExpressionMap.get(displayPolicyExpression.getCalculateCycle());
            if (CollectionUtils.isEmpty((Collection)expressions)) {
                expressions = Lists.newArrayList();
            }
            expressions.add(displayPolicyExpression);
            displayExpressionMap.put(displayPolicyExpression.getCalculateCycle(), expressions);
        });
        return displayExpressionMap;
    }

    private List<DisplayTaskDetail> calculateWithOnlyHighestLevel(DisplayCalculateTask displayCalculateTask, BigDecimal scanCount, BigDecimal reachRate) {
        ArrayList quantifyTaskDetails = Lists.newArrayList();
        if (CollectionUtils.isEmpty(displayCalculateTask.getDisplayTaskExpressionList())) {
            return quantifyTaskDetails;
        }
        displayCalculateTask.getDisplayTaskExpressionList().sort((o1, o2) -> o2.getReachRate().compareTo(o1.getReachRate()));
        BigDecimal alreadyReachRate = null;
        for (DisplayTaskExpression expression : displayCalculateTask.getDisplayTaskExpressionList()) {
            DisplayTaskDetail taskDetail = (DisplayTaskDetail)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)expression, DisplayTaskDetail.class, Set.class, ArrayList.class, new String[0]));
            taskDetail.setId(null);
            taskDetail.setBusinessCode(displayCalculateTask.getBusinessCode());
            taskDetail.setSaleTarget(displayCalculateTask.getSaleTarget());
            taskDetail.setActualSales(scanCount);
            taskDetail.setReachRate(reachRate);
            if (!Objects.isNull(alreadyReachRate)) {
                if (alreadyReachRate.compareTo(expression.getReachRate()) == 0) {
                    taskDetail.setProfitStatus(reachRate.compareTo(expression.getReachRate()) > -1 ? AutoSignEnum.YES.getCode() : AutoSignEnum.NO.getCode());
                } else {
                    taskDetail.setProfitStatus(AutoSignEnum.NO.getCode());
                }
            } else {
                taskDetail.setProfitStatus(reachRate.compareTo(expression.getReachRate()) > -1 ? AutoSignEnum.YES.getCode() : AutoSignEnum.NO.getCode());
                alreadyReachRate = taskDetail.getProfitStatus().equals(AutoSignEnum.YES.getCode()) ? expression.getReachRate() : null;
            }
            quantifyTaskDetails.add(taskDetail);
        }
        return quantifyTaskDetails;
    }

    private List<DisplayTaskDetail> calculateWithAllLevel(DisplayCalculateTask displayCalculateTask, BigDecimal scanCount, BigDecimal reachRate) {
        ArrayList quantifyTaskDetails = Lists.newArrayList();
        if (CollectionUtils.isEmpty(displayCalculateTask.getDisplayTaskExpressionList())) {
            return quantifyTaskDetails;
        }
        displayCalculateTask.getDisplayTaskExpressionList().sort((o1, o2) -> o2.getReachRate().compareTo(o1.getReachRate()));
        for (DisplayTaskExpression expression : displayCalculateTask.getDisplayTaskExpressionList()) {
            DisplayTaskDetail taskDetail = (DisplayTaskDetail)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)expression, DisplayTaskDetail.class, Set.class, ArrayList.class, new String[0]));
            taskDetail.setId(null);
            taskDetail.setBusinessCode(displayCalculateTask.getBusinessCode());
            taskDetail.setSaleTarget(displayCalculateTask.getSaleTarget());
            taskDetail.setActualSales(scanCount);
            taskDetail.setReachRate(reachRate);
            taskDetail.setProfitStatus(reachRate.compareTo(expression.getReachRate()) > -1 ? AutoSignEnum.YES.getCode() : AutoSignEnum.NO.getCode());
            quantifyTaskDetails.add(taskDetail);
        }
        return quantifyTaskDetails;
    }

    private Boolean validateTimeBetween(DisplayCalculateTask calculateTask, DisplayTask task) {
        Boolean f = Objects.isNull(calculateTask.getTaskStartTime()) || Objects.isNull(calculateTask.getTaskEndTime()) || Objects.isNull(task.getTaskStartTime()) || Objects.isNull(task.getTaskEndTime());
        if (f.booleanValue()) {
            return false;
        }
        return calculateTask.getTaskStartTime().compareTo(task.getTaskStartTime()) <= 0 && calculateTask.getTaskEndTime().compareTo(task.getTaskEndTime()) >= 0;
    }
}

