/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.display.ladder.local.service.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.bisiness.policy.display.sdk.vo.DisplayConfigurationVo;
import com.biz.crm.cps.bisiness.policy.display.sdk.vo.DisplayTaskUploadDetailVo;
import com.biz.crm.cps.bisiness.policy.display.sdk.vo.DisplayTaskUploadVo;
import com.biz.crm.cps.bisiness.policy.display.sdk.vo.DisplayTaskVo;
import com.biz.crm.cps.bisiness.policy.display.sdk.vo.TerminalBaseVo;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicy;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicyConfiguration;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTask;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTaskUpload;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayTaskUploadDetail;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayPolicyConfigurationRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayPolicyRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayTaskRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayTaskUploadDetailRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.repository.DisplayTaskUploadRepository;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayTaskVoService;
import com.biz.crm.cps.external.mdm.sdk.service.TerminalMdmService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DisplayTaskVoServiceImpl
implements DisplayTaskVoService {
    @Autowired
    private DisplayTaskRepository displayTaskRepository;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private DisplayPolicyConfigurationRepository displayPolicyConfigurationRepository;
    @Autowired
    private DisplayPolicyRepository displayPolicyRepository;
    @Autowired
    private DisplayTaskUploadRepository uploadRepository;
    @Autowired(required=false)
    private TerminalMdmService terminalMdmService;
    @Autowired
    private DisplayTaskUploadDetailRepository displayTaskUploadDetailRepository;
    @Autowired
    private LoginUserService loginUserService;

    @Override
    public DisplayTaskVo findByBusinessCode(String businessCode) {
        List<DisplayTaskUploadDetail> SampleGraphs;
        if (StringUtils.isBlank((CharSequence)businessCode)) {
            return null;
        }
        DisplayTask displayTask = this.displayTaskRepository.findByBusinessCode(businessCode);
        DisplayTaskVo displayTaskVo = (DisplayTaskVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)displayTask, DisplayTaskVo.class, HashSet.class, ArrayList.class, new String[0]);
        List<DisplayPolicyConfiguration> configurations = this.displayPolicyConfigurationRepository.findByDisplayPolicyId(displayTask.getDisplayPolicyId());
        Collection configurationVos = this.nebulaToolkitService.copyCollectionByWhiteList(configurations, DisplayPolicyConfiguration.class, DisplayConfigurationVo.class, HashSet.class, ArrayList.class, new String[]{"displayPolicyRanges", "displayPolicyExpressions"});
        HashSet configurationVoSet = new HashSet(configurationVos);
        DisplayPolicy displayPolicy = this.displayPolicyRepository.findById(displayTask.getDisplayPolicyId());
        List<DisplayTaskUpload> taskUploads = this.uploadRepository.findByBusinessCode(displayTask.getBusinessCode());
        Collection displayTaskUploadVos = this.nebulaToolkitService.copyCollectionByWhiteList(taskUploads, DisplayTaskUpload.class, DisplayTaskUploadVo.class, HashSet.class, ArrayList.class, new String[0]);
        HashSet displayTaskUploadVoSet = new HashSet(displayTaskUploadVos);
        HashSet codes = Sets.newHashSet((Object[])new String[]{displayTask.getTerminalCode()});
        List detailByCodes = this.terminalMdmService.findDetailByCodes((Set)codes);
        TerminalBaseVo terminalBaseVo = new TerminalBaseVo();
        if (!CollectionUtils.isEmpty((Collection)detailByCodes)) {
            terminalBaseVo = (TerminalBaseVo)this.nebulaToolkitService.copyObjectByWhiteList(detailByCodes.get(0), TerminalBaseVo.class, HashSet.class, ArrayList.class, new String[0]);
        }
        if (!CollectionUtils.isEmpty(SampleGraphs = this.displayTaskUploadDetailRepository.findByBusinessCode(displayPolicy.getId()))) {
            Collection displaySampleGraphVos = this.nebulaToolkitService.copyCollectionByWhiteList(SampleGraphs, DisplayTaskUploadDetail.class, DisplayTaskUploadDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
            displayTaskVo.setDisplaySampleGraphs(new HashSet(displaySampleGraphVos));
        }
        displayTaskVo.setDisplayConfigurations(configurationVoSet);
        displayTaskVo.setDisplayType(displayPolicy.getDisplayType());
        displayTaskVo.setDisplayTaskUploads(displayTaskUploadVoSet);
        displayTaskVo.setTerminalBaseVo(terminalBaseVo);
        return displayTaskVo;
    }

    @Override
    public List<DisplayTaskVo> findByTerminalCode(String taskStatus) {
        LoginUserDetailsForCPS loginUser = (LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
        Validate.notNull((Object)loginUser, (String)"\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f\u5931\u8d25", (Object[])new Object[0]);
        String terminalCode = loginUser.getConsumerCode();
        if (StringUtils.isBlank((CharSequence)terminalCode)) {
            return null;
        }
        List<DisplayTask> displayTasks = this.displayTaskRepository.findByTerminalCode(terminalCode, taskStatus);
        if (CollectionUtils.isEmpty(displayTasks)) {
            return null;
        }
        return new ArrayList<DisplayTaskVo>(this.nebulaToolkitService.copyCollectionByWhiteList(displayTasks, DisplayTask.class, DisplayTaskVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    @Override
    public DisplayTaskVo findPictureByBusinessCode(String businessCode) {
        if (StringUtils.isBlank((CharSequence)businessCode)) {
            return null;
        }
        DisplayTask displayTask = this.displayTaskRepository.findByBusinessCode(businessCode);
        List<DisplayTaskUpload> uploads = this.uploadRepository.findByBusinessCode(businessCode);
        if (CollectionUtils.isEmpty(uploads) || displayTask == null) {
            return null;
        }
        HashSet displayTaskUploadVos = new HashSet(this.nebulaToolkitService.copyCollectionByWhiteList(uploads, DisplayTaskUpload.class, DisplayTaskUploadVo.class, HashSet.class, ArrayList.class, new String[]{"displayTaskUploadDetails"}));
        DisplayTaskVo displayTaskVo = new DisplayTaskVo();
        displayTaskVo.setDisplayTaskUploads(displayTaskUploadVos);
        displayTaskVo.setAiAuditResult(displayTask.getAiAuditResult());
        return displayTaskVo;
    }
}

