/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.display.ladder.local.service.notifier;

import cn.hutool.json.JSONUtil;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayCalculateTaskService;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordEventDto;
import com.biz.crm.cps.external.barcode.sdk.event.ScanCodeRecordEventListener;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DisplayTaskEventListenerImpl
implements ScanCodeRecordEventListener {
    private static final Logger log = LoggerFactory.getLogger(DisplayTaskEventListenerImpl.class);
    @Autowired
    private DisplayCalculateTaskService displayCalculateTaskService;

    public void onSuccessScan(ScanCodeRecordEventDto dto) {
        log.info("\u8d22\u5e74\u5305\u91cf\u653f\u7b56\u626b\u7801\u4e8b\u4ef6\u5b9e\u73b0\u5904\u7406[{}]", (Object)JSONUtil.toJsonStr((Object)dto));
        if (Objects.isNull(dto) || StringUtils.isBlank((CharSequence)dto.getBarCode()) || StringUtils.isBlank((CharSequence)dto.getProductCode())) {
            return;
        }
        this.displayCalculateTaskService.updateScanInfoByProductCodeAndBarCode(dto.getProductCode(), dto.getBarCode());
    }

    public void onFailScan(ScanCodeRecordEventDto dto) {
    }
}

