/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.display.ladder.local.service.observer;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.bisiness.policy.display.sdk.dto.DisplayPolicyDto;
import com.biz.crm.cps.bisiness.policy.display.sdk.vo.DisplayPolicyUploadRuleVo;
import com.biz.crm.cps.bisiness.policy.display.sdk.vo.DisplayPolicyVo;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementPolicyDto;
import com.biz.crm.cps.business.agreement.sdk.dto.PolicyObserverDto;
import com.biz.crm.cps.business.agreement.sdk.service.observer.AgreementPolicyServiceObserver;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementPolicyVo;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementTemplateVo;
import com.biz.crm.cps.business.agreement.sdk.vo.PolicyRewardDataVo;
import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicy;
import com.biz.crm.cps.business.policy.display.ladder.local.service.DisplayPolicyService;
import com.biz.crm.cps.business.policy.display.ladder.local.service.observer.DisplayPolicyMountRegisterImpl;
import com.biz.crm.cps.business.policy.display.ladder.local.service.observer.DisplayPolicyPojoObserverImpl;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component(value="DisplayPolicyServiceObserverImpl")
public class DisplayPolicyServiceObserverImpl
implements AgreementPolicyServiceObserver {
    @Autowired
    private DisplayPolicyService displayPolicyService;
    @Autowired
    private DisplayPolicyPojoObserverImpl displayPolicyPojoObserver;
    @Autowired
    private DisplayPolicyMountRegisterImpl displayPolicyMountRegister;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    public void onCreate(AgreementPolicyDto agreementPolicyDto) {
        this.displayPolicyService.create(agreementPolicyDto);
    }

    public AgreementPolicyVo onFindDetailsByTemplateCode(String templateCode) {
        DisplayPolicy displayPolicy = this.displayPolicyService.findByTemplateCode(templateCode);
        if (ObjectUtils.isEmpty((Object)((Object)displayPolicy))) {
            return null;
        }
        DisplayPolicyVo displayPolicyVo = (DisplayPolicyVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)displayPolicy, DisplayPolicyVo.class, HashSet.class, ArrayList.class, new String[]{"saleTarget", "uploadRules", "displayPolicyConfigurations", "displayPolicyConfigurations.displayPolicyRanges", "displayPolicyConfigurations.displayPolicyExpressions", "displaySampleGraphs"});
        displayPolicyVo.setPolicyKey(this.displayPolicyMountRegister.getKey());
        displayPolicyVo.setTemplateCode(templateCode);
        if (!CollectionUtils.isEmpty((Collection)displayPolicyVo.getUploadRules())) {
            List uploadRuleVos = displayPolicyVo.getUploadRules().stream().sorted(Comparator.comparing(DisplayPolicyUploadRuleVo::getOrderNum)).collect(Collectors.toList());
            displayPolicyVo.setUploadRules(uploadRuleVos);
        }
        return displayPolicyVo;
    }

    public void onProcessScanCode(PolicyObserverDto policyObserverDto) {
        super.onProcessScanCode(policyObserverDto);
    }

    public void onCreate(JSONObject jsonObject) {
        if (ObjectUtils.isEmpty((Object)jsonObject)) {
            return;
        }
        JSONObject policy = jsonObject.getJSONObject(this.displayPolicyMountRegister.getKey());
        DisplayPolicyDto deserialize = this.displayPolicyPojoObserver.deserialize(policy);
        if (deserialize == null) {
            return;
        }
        deserialize.setTemplateCode(jsonObject.getString("templateCode"));
        AgreementTemplateVo agreementTemplateVo = (AgreementTemplateVo)JsonUtils.json2Obj((String)jsonObject.getString("profitAgreementTemplate"), AgreementTemplateVo.class);
        this.displayPolicyService.validatePolicyScope(agreementTemplateVo, (AgreementPolicyDto)deserialize);
        this.onCreate((AgreementPolicyDto)deserialize);
    }

    public List<PolicyRewardDataVo> onFindPolicyRewardData(Set<String> templateCodeSet, String usertype) {
        return null;
    }

    public void onChange(JSONObject jsonObject) {
        if (ObjectUtils.isEmpty((Object)jsonObject)) {
            return;
        }
        JSONObject policy = jsonObject.getJSONObject(this.displayPolicyMountRegister.getKey());
        DisplayPolicyDto deserialize = this.displayPolicyPojoObserver.deserialize(policy);
        if (deserialize == null) {
            return;
        }
        deserialize.setTemplateCode(jsonObject.getString("templateCode"));
        AgreementTemplateVo agreementTemplateVo = (AgreementTemplateVo)JsonUtils.json2Obj((String)jsonObject.getString("profitAgreementTemplate"), AgreementTemplateVo.class);
        this.displayPolicyService.validatePolicyScope(agreementTemplateVo, (AgreementPolicyDto)deserialize);
        Boolean before = jsonObject.getBoolean("before");
        this.displayPolicyService.update((AgreementPolicyDto)deserialize, before);
    }
}

