/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.display.ladder.local.utils;

import com.biz.crm.cps.business.policy.display.ladder.local.entity.DisplayPolicySaleTarget;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;

public class DisplayPolicyUtils {
    public static BigDecimal getScaleByMonth(int month, DisplayPolicySaleTarget saleTarget) {
        switch (month) {
            case 1: {
                return saleTarget.getJanuarySaleNum();
            }
            case 2: {
                return saleTarget.getFebruarySaleNum();
            }
            case 3: {
                return saleTarget.getMarchSaleNum();
            }
            case 4: {
                return saleTarget.getAprilSaleNum();
            }
            case 5: {
                return saleTarget.getMaySaleNum();
            }
            case 6: {
                return saleTarget.getJuneSaleNum();
            }
            case 7: {
                return saleTarget.getJulySaleNum();
            }
            case 8: {
                return saleTarget.getAugustSaleNum();
            }
            case 9: {
                return saleTarget.getSeptemberSaleNum();
            }
            case 10: {
                return saleTarget.getOctoberSaleNum();
            }
            case 11: {
                return saleTarget.getNovemberSaleNum();
            }
        }
        return saleTarget.getDecemberSaleNum();
    }

    public static BigDecimal getScaleByTimeInterval(Date startTime, Date endTime, DisplayPolicySaleTarget saleTarget) {
        BigDecimal target = BigDecimal.ZERO;
        while (startTime.before(endTime)) {
            target = target.add(DisplayPolicyUtils.getScaleByMonth(startTime.getMonth() + 1, saleTarget));
            startTime = DateUtils.ceiling((Date)startTime, (int)2);
        }
        return target;
    }
}

