/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.display.ladder.controller;

import com.biz.crm.cps.bisiness.policy.display.sdk.dto.DisplayTaskDto;
import com.biz.crm.cps.bisiness.policy.display.sdk.dto.DisplayTaskUploadInfoDto;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.policy.display.ladder.entity.DisplayTask;
import com.biz.crm.cps.business.policy.display.ladder.service.DisplayTaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/display/task"})
@Api(tags={"\u9648\u5217\u4efb\u52a1\u76f8\u5173\u63a5\u53e3"})
public class DisplayTaskController {
    private static final Logger log = LoggerFactory.getLogger(DisplayTaskController.class);
    @Autowired
    private DisplayTaskService displayTaskService;

    @ApiOperation(value="\u521b\u5efa\u9648\u5217\u4efb\u52a1(\u5f00\u53d1\u81ea\u6d4b)")
    @PostMapping(value={""})
    public Result<List<DisplayTask>> create(@RequestBody String agreementId) {
        try {
            List<DisplayTask> displayTasks = this.displayTaskService.create(agreementId);
            return Result.ok(displayTasks);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4efb\u52a1\u624b\u52a8\u7ed3\u7b97")
    @GetMapping(value={"settlementDisplayTask"})
    public Result<?> handleSettlementTask(@RequestParam String businessCode) {
        try {
            this.displayTaskService.handleSettlementTask(businessCode);
            return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u5ba1\u6838\u72b6\u6001(\u4eba\u5de5\u5ba1\u6838)")
    @PatchMapping(value={"updateTaskStatus"})
    public Result<?> updateTaskStatus(@RequestBody DisplayTaskDto displayTaskDto) {
        try {
            this.displayTaskService.updateTaskStatus(displayTaskDto);
            return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u63d0\u4ea4\u9648\u5217\u4efb\u52a1\u56fe\u7247\u4fe1\u606f")
    @PostMapping(value={"submitDisplayTaskPictureInfo"})
    public Result<?> handleSubmitDisplayTask(@RequestBody DisplayTaskUploadInfoDto displayTaskUploadInfoDto) {
        try {
            this.displayTaskService.handleSubmitDisplayTask(displayTaskUploadInfoDto);
            return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

