/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.display.ladder.service.builder;

import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.DisplayTaskStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.policy.display.ladder.entity.DisplayCalculateTask;
import com.biz.crm.cps.business.policy.display.ladder.entity.DisplayPolicy;
import com.biz.crm.cps.business.policy.display.ladder.service.builder.DisplayCalculateTaskBuilder;
import com.biz.crm.cps.business.policy.display.ladder.utils.DisplayPolicyUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.stereotype.Component;

@Component
public class DisplayCalculateTaskMonthBuilder
implements DisplayCalculateTaskBuilder {
    @Override
    public List<DisplayCalculateTask> handleAssemblyDisplayCalculateTask(AgreementVo agreementVo, DisplayPolicy displayPolicy) {
        ArrayList taskList = Lists.newArrayList();
        if (!ObjectUtils.allNotNull((Object[])new Object[]{agreementVo, displayPolicy})) {
            return taskList;
        }
        Date effectiveTime = agreementVo.getEffectiveStartTime();
        Date now = new Date();
        DisplayTaskStatusEnum statusEnum = DisplayTaskStatusEnum.STATUS_WAIT;
        if (effectiveTime.before(now)) {
            statusEnum = DisplayTaskStatusEnum.STATUS_DOING;
        }
        while (effectiveTime.before(agreementVo.getEffectiveEndTime())) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(effectiveTime);
            int nowMonth = calendar.get(2) + 1;
            int nowYear = calendar.get(1);
            DisplayCalculateTask displayCalculateTask = new DisplayCalculateTask();
            displayCalculateTask.setTaskStartTime(effectiveTime);
            displayCalculateTask.setTaskEndTime(DateUtils.addSeconds((Date)DateUtils.ceiling((Date)effectiveTime, (int)2), (int)-1));
            displayCalculateTask.setTaskName(nowYear + "\u5e74\u7b2c" + nowMonth + "\u6708\u9648\u5217\u7ed3\u7b97\u4efb\u52a1");
            displayCalculateTask.setTaskStatus(statusEnum.getDictCode());
            displayCalculateTask.setSaleTarget(DisplayPolicyUtils.getScaleByMonth(nowMonth, displayPolicy.getSaleTarget()));
            taskList.add(displayCalculateTask);
            statusEnum = DisplayTaskStatusEnum.STATUS_WAIT;
            effectiveTime = DateUtils.ceiling((Date)effectiveTime, (int)2);
        }
        return taskList;
    }

    @Override
    public String quantifyTaskCycle() {
        return "month";
    }
}

