/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.display.ladder.service.builder;

import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.BindStatusEnum;
import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.DisplayTaskStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.policy.display.ladder.entity.DisplayPolicy;
import com.biz.crm.cps.business.policy.display.ladder.entity.DisplayPolicyUploadRule;
import com.biz.crm.cps.business.policy.display.ladder.entity.DisplayTask;
import com.biz.crm.cps.business.policy.display.ladder.service.builder.DisplayTaskBuilder;
import com.biz.crm.cps.business.policy.display.ladder.utils.DisplayPolicyUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.util.CollectionUtils;

public class DisplayTaskDefaultBuilder
implements DisplayTaskBuilder {
    @Override
    public List<DisplayTask> handleAssemblyDisplayTask(AgreementVo agreementVo, DisplayPolicy displayPolicy) {
        ArrayList taskList = Lists.newArrayList();
        if (!ObjectUtils.allNotNull((Object[])new Object[]{agreementVo, displayPolicy})) {
            return taskList;
        }
        Date effectiveTime = agreementVo.getEffectiveStartTime();
        Date now = new Date();
        DisplayTaskStatusEnum statusEnum = DisplayTaskStatusEnum.STATUS_NOT_BEGIN;
        if (effectiveTime.before(now)) {
            effectiveTime = now;
            statusEnum = DisplayTaskStatusEnum.STATUS_WAIT;
        }
        while (effectiveTime.before(agreementVo.getEffectiveEndTime())) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(effectiveTime);
            int nowMonth = calendar.get(2) + 1;
            int nowYear = calendar.get(1);
            Validate.isTrue((!CollectionUtils.isEmpty(displayPolicy.getUploadRules()) ? 1 : 0) != 0, (String)"\u5bf9\u5e94\u9648\u5217\u653f\u7b56\u4e0a\u4f20\u89c4\u5219\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            List uploadRuleList = displayPolicy.getUploadRules().stream().sorted(Comparator.comparing(DisplayPolicyUploadRule::getOrderNum)).collect(Collectors.toList());
            Validate.isTrue((!CollectionUtils.isEmpty(uploadRuleList) ? 1 : 0) != 0, (String)"\u5bf9\u5e94\u9648\u5217\u653f\u7b56\u4e0a\u4f20\u89c4\u5219\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            for (DisplayPolicyUploadRule uploadRule : uploadRuleList) {
                effectiveTime = DateUtils.setDays((Date)DateUtils.ceiling((Date)effectiveTime, (int)5), (int)uploadRule.getStartDay());
                Date endTime = DateUtils.addSeconds((Date)DateUtils.setDays((Date)effectiveTime, (int)(uploadRule.getEndDay() + 1)), (int)-1);
                if (taskList.size() == 0 && endTime.before(now)) continue;
                DisplayTask displayTask = new DisplayTask();
                displayTask.setTaskStartTime(effectiveTime);
                displayTask.setTaskEndTime(endTime);
                displayTask.setTaskName(nowYear + "\u5e74" + nowMonth + "\u6708\u7b2c" + uploadRule.getOrderNum() + "\u6b21\u4efb\u52a1");
                displayTask.setTaskStatus(statusEnum.getDictCode());
                displayTask.setEffectiveStartTime(agreementVo.getEffectiveStartTime());
                displayTask.setEffectiveEndTime(agreementVo.getEffectiveEndTime());
                if (BindStatusEnum.YES.getDictCode().equals(displayPolicy.getBindSaleStatus())) {
                    displayTask.setSaleTarget(DisplayPolicyUtils.getScaleByMonth(nowMonth, displayPolicy.getSaleTarget()));
                } else {
                    displayTask.setSaleTarget(BigDecimal.ZERO);
                }
                displayTask.setBindSaleStatus(displayPolicy.getBindSaleStatus());
                taskList.add(displayTask);
                statusEnum = DisplayTaskStatusEnum.STATUS_NOT_BEGIN;
            }
            effectiveTime = DateUtils.addMonths((Date)effectiveTime, (int)1);
        }
        return taskList;
    }
}

