/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.display.ladder.controller;

import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.policy.display.ladder.entity.DisplayPolicy;
import com.biz.crm.cps.business.policy.display.ladder.service.DisplayPolicyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/display/policy"})
@Api(tags={"\u9648\u5217\u653f\u7b56\u76f8\u5173\u63a5\u53e3"})
public class DisplayPolicyController {
    private static final Logger log = LoggerFactory.getLogger(DisplayPolicyController.class);
    @Autowired
    private DisplayPolicyService displayPolicyService;

    @ApiOperation(value="\u521b\u5efa\u9648\u5217\u653f\u7b56(\u5f00\u53d1\u81ea\u6d4b)")
    @PostMapping(value={""})
    public Result<DisplayPolicy> create(@RequestBody DisplayPolicy displayPolicy) {
        try {
            DisplayPolicy policy = this.displayPolicyService.createFrom(displayPolicy);
            return Result.ok((Object)((Object)policy));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521b\u5efa\u9648\u5217\u653f\u7b56(\u5f00\u53d1\u81ea\u6d4b)")
    @GetMapping(value={"findByTemplateCode"})
    public Result<DisplayPolicy> findByTemplateCode(@RequestParam String templateCode) {
        try {
            DisplayPolicy policy = this.displayPolicyService.findByTemplateCode(templateCode);
            return Result.ok((Object)((Object)policy));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

