/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.display.ladder.service.builder;

import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.DisplayTaskStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.common.sdk.enums.ActivityCycleEnum;
import com.biz.crm.cps.business.policy.display.ladder.entity.DisplayCalculateTask;
import com.biz.crm.cps.business.policy.display.ladder.entity.DisplayPolicy;
import com.biz.crm.cps.business.policy.display.ladder.service.builder.DisplayCalculateTaskBuilder;
import com.biz.crm.cps.business.policy.display.ladder.utils.DisplayPolicyUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.stereotype.Component;

@Component
public class DisplayCalculateTaskSeasonBuilder
implements DisplayCalculateTaskBuilder {
    @Override
    public List<DisplayCalculateTask> handleAssemblyDisplayCalculateTask(AgreementVo agreementVo, DisplayPolicy displayPolicy) {
        ArrayList taskList = Lists.newArrayList();
        if (!ObjectUtils.allNotNull((Object[])new Object[]{agreementVo, displayPolicy})) {
            return taskList;
        }
        Date effectiveTime = agreementVo.getEffectiveStartTime();
        Date now = new Date();
        DisplayTaskStatusEnum statusEnum = DisplayTaskStatusEnum.STATUS_WAIT;
        if (effectiveTime.before(now)) {
            statusEnum = DisplayTaskStatusEnum.STATUS_DOING;
        }
        while (effectiveTime.before(agreementVo.getEffectiveEndTime())) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(effectiveTime);
            int nowMonth = calendar.get(2) + 1;
            int nowYear = calendar.get(1);
            int addMonths = nowMonth % 3;
            DisplayCalculateTask displayCalculateTask = new DisplayCalculateTask();
            displayCalculateTask.setTaskStartTime(effectiveTime);
            int nowSeason = nowMonth % 3 == 0 ? nowMonth / 3 : nowMonth / 3 + 1;
            displayCalculateTask.setTaskStartTime(this.getSeasonFirstDay(calendar));
            displayCalculateTask.setTaskName(nowYear + "\u5e74\u7b2c" + nowSeason + "\u5b63\u5ea6\u9648\u5217\u8ba1\u7b97\u4efb\u52a1");
            switch (nowSeason) {
                case 1: {
                    displayCalculateTask.setTaskTypeValue(ActivityCycleEnum.FIRST.getDictCode());
                    break;
                }
                case 2: {
                    displayCalculateTask.setTaskTypeValue(ActivityCycleEnum.SECOND.getDictCode());
                    break;
                }
                case 3: {
                    displayCalculateTask.setTaskTypeValue(ActivityCycleEnum.THIRD.getDictCode());
                    break;
                }
                case 4: {
                    displayCalculateTask.setTaskTypeValue(ActivityCycleEnum.FOURTH.getDictCode());
                }
            }
            displayCalculateTask.setTaskStatus(statusEnum.getDictCode());
            effectiveTime = addMonths == 0 ? DateUtils.ceiling((Date)effectiveTime, (int)2) : DateUtils.addMonths((Date)DateUtils.ceiling((Date)effectiveTime, (int)2), (int)(3 - addMonths));
            displayCalculateTask.setTaskEndTime(DateUtils.addSeconds((Date)effectiveTime, (int)-1));
            displayCalculateTask.setSaleTarget(DisplayPolicyUtils.getScaleByTimeInterval(displayCalculateTask.getTaskStartTime(), displayCalculateTask.getTaskEndTime(), displayPolicy.getSaleTarget()));
            taskList.add(displayCalculateTask);
            statusEnum = DisplayTaskStatusEnum.STATUS_WAIT;
        }
        return taskList;
    }

    private Date getSeasonFirstDay(Calendar calendar) {
        int nowMonth = calendar.get(2) + 1;
        int nowSeason = nowMonth % 3 == 0 ? nowMonth / 3 : nowMonth / 3 + 1;
        int startMonth = 1;
        if (nowSeason == 2) {
            startMonth = 4;
        } else if (nowSeason == 3) {
            startMonth = 7;
        } else if (nowSeason == 4) {
            startMonth = 10;
        }
        calendar.set(2, startMonth - 1);
        calendar.set(5, 1);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    @Override
    public String quantifyTaskCycle() {
        return "season";
    }
}

