/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.display.ladder.service.internal;

import com.biz.crm.cps.business.agreement.sdk.dto.AgreementPolicyDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementLadderVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementLadderVo;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.policy.display.ladder.entity.DisplayPolicy;
import com.biz.crm.cps.business.policy.display.ladder.entity.DisplayPolicyExpression;
import com.biz.crm.cps.business.policy.display.ladder.entity.DisplayPolicyRange;
import com.biz.crm.cps.business.policy.display.ladder.entity.DisplayPolicySaleTarget;
import com.biz.crm.cps.business.policy.display.ladder.entity.DisplayPolicyUploadRule;
import com.biz.crm.cps.business.policy.display.ladder.repository.DisplayPolicyConfigurationRepository;
import com.biz.crm.cps.business.policy.display.ladder.repository.DisplayPolicyExpressionRepository;
import com.biz.crm.cps.business.policy.display.ladder.repository.DisplayPolicyRangeRepository;
import com.biz.crm.cps.business.policy.display.ladder.repository.DisplayPolicyRepository;
import com.biz.crm.cps.business.policy.display.ladder.repository.DisplayPolicySaleTargetRepository;
import com.biz.crm.cps.business.policy.display.ladder.repository.DisplayPolicyUploadRuleRepository;
import com.biz.crm.cps.business.policy.display.ladder.repository.DisplayTaskUploadRepository;
import com.biz.crm.cps.business.policy.display.ladder.service.DisplayPolicyService;
import com.biz.crm.cps.business.product.sdk.service.MaterialVoService;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class DisplayPolicyServiceImpl
implements DisplayPolicyService {
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired
    private DisplayPolicyRepository policyRepository;
    @Autowired
    private DisplayPolicyConfigurationRepository configurationRepository;
    @Autowired
    private DisplayPolicyRangeRepository rangeRepository;
    @Autowired
    private DisplayPolicyExpressionRepository expressionRepository;
    @Autowired
    private DisplayPolicySaleTargetRepository saleTargetRepository;
    @Autowired
    private DisplayPolicyUploadRuleRepository uploadRuleRepository;
    @Autowired
    private DisplayTaskUploadRepository displayTaskUploadRepository;
    @Autowired
    private MaterialVoService materialVoService;
    @Autowired
    private AgreementLadderVoService agreementLadderVoService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public DisplayPolicy create(AgreementPolicyDto agreementPolicyDto) {
        if (agreementPolicyDto == null) {
            return null;
        }
        DisplayPolicy displayPolicy = (DisplayPolicy)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)agreementPolicyDto, DisplayPolicy.class, HashSet.class, ArrayList.class, new String[]{"saleTarget", "uploadRules", "displayPolicyConfigurations", "displayPolicyConfigurations.displayPolicyRanges", "displayPolicyConfigurations.displayPolicyExpressions", "displaySampleGraphs"}));
        return this.createFrom(displayPolicy);
    }

    @Override
    @Transactional
    public DisplayPolicy createFrom(DisplayPolicy displayPolicy) {
        this.createValidation(displayPolicy);
        Date now = new Date();
        displayPolicy.setCreateTime(now);
        displayPolicy.setModifyTime(now);
        displayPolicy.setCreateAccount(this.loginUserService.getLoginAccountName());
        displayPolicy.setModifyAccount(this.loginUserService.getLoginAccountName());
        displayPolicy.setUploadTimes(displayPolicy.getUploadRules().size());
        ArrayList dimensionCodes = Lists.newArrayList();
        this.policyRepository.save((Object)displayPolicy);
        DisplayPolicySaleTarget saleTarget = displayPolicy.getSaleTarget();
        saleTarget.setDisplayPolicyId(displayPolicy.getId());
        this.saleTargetRepository.save((Object)displayPolicy.getSaleTarget());
        if (!CollectionUtils.isEmpty(displayPolicy.getDisplaySampleGraphs())) {
            displayPolicy.getDisplaySampleGraphs().forEach(sampleGraph -> sampleGraph.setBusinessCode(displayPolicy.getId()));
            this.displayTaskUploadRepository.saveBatch(displayPolicy.getDisplaySampleGraphs());
        }
        displayPolicy.getUploadRules().forEach(displayPolicyUploadRule -> displayPolicyUploadRule.setDisplayPolicyId(displayPolicy.getId()));
        this.uploadRuleRepository.saveBatch(displayPolicy.getUploadRules());
        displayPolicy.getDisplayPolicyConfigurations().forEach(policyConfiguration -> {
            policyConfiguration.setDisplayPolicyId(displayPolicy.getId());
            AgreementLadderVo agreementLadderVo = this.agreementLadderVoService.findByLadderCode(policyConfiguration.getAgreementLadderCode());
            if (ObjectUtils.allNotNull((Object[])new Object[]{agreementLadderVo})) {
                policyConfiguration.setDisplayNumber(agreementLadderVo.getDisplayNumber());
            }
            this.configurationRepository.save(policyConfiguration);
            policyConfiguration.getDisplayPolicyRanges().forEach(displayPolicyRange -> {
                dimensionCodes.add(displayPolicyRange.getSpecialCode());
                displayPolicyRange.setConfigurationId(policyConfiguration.getId());
            });
            this.rangeRepository.saveBatch(policyConfiguration.getDisplayPolicyRanges());
            policyConfiguration.getDisplayPolicyExpressions().forEach(policyExpression -> policyExpression.setConfigurationId(policyConfiguration.getId()));
            this.expressionRepository.saveBatch(policyConfiguration.getDisplayPolicyExpressions());
        });
        CompletableFuture.runAsync(() -> this.materialVoService.sync(dimensionCodes, displayPolicy.getDimensionFlag()));
        return displayPolicy;
    }

    @Override
    public DisplayPolicy findByTemplateCode(String templateCode) {
        return this.policyRepository.findDetailByTemplateCode(templateCode);
    }

    @Override
    public DisplayPolicy findById(String displayPolicyId) {
        return this.policyRepository.findDetailsById(displayPolicyId);
    }

    private void createValidation(DisplayPolicy displayPolicy) {
        Validate.notNull((Object)((Object)displayPolicy), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u9648\u5217\u653f\u7b56\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        displayPolicy.setId(null);
        if (StringUtils.isBlank((CharSequence)displayPolicy.getTenantCode())) {
            displayPolicy.setTenantCode(TenantUtils.getTenantCode());
        }
        Validate.isTrue((!CollectionUtils.isEmpty(displayPolicy.getDisplaySampleGraphs()) ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u9648\u5217\u793a\u4f8b\u56fe\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(displayPolicy.getDisplayPolicyConfigurations()) ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u653f\u7b56\u914d\u7f6e\u884c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(displayPolicy.getUploadRules()) ? 1 : 0) != 0, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u9648\u5217\u7167\u4e0a\u4f20\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)displayPolicy.getDimensionFlag(), (String)"\u4ea7\u54c1\u7ef4\u5ea6\u6807\u8bb0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)displayPolicy.getDimensionName(), (String)"\u4ea7\u54c1\u7ef4\u5ea6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        displayPolicy.getDisplayPolicyConfigurations().forEach(displayPolicyConfiguration -> {
            Validate.notBlank((CharSequence)displayPolicyConfiguration.getAgreementLadderCode(), (String)"\u9636\u68af\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            if (!displayPolicy.getDimensionFlag().equals("DIMENSION_ALL")) {
                Validate.isTrue((!CollectionUtils.isEmpty(displayPolicyConfiguration.getDisplayPolicyRanges()) ? 1 : 0) != 0, (String)"\u653f\u7b56\u5173\u8054\u4ea7\u54c1\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                displayPolicyConfiguration.getDisplayPolicyRanges().forEach(this::displayRangeValidation);
            }
            Validate.isTrue((!CollectionUtils.isEmpty(displayPolicyConfiguration.getDisplayPolicyExpressions()) ? 1 : 0) != 0, (String)"\u653f\u7b56\u5173\u8054\u5206\u5229\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            for (DisplayPolicyExpression expression : displayPolicyConfiguration.getDisplayPolicyExpressions()) {
                if (!"gift".equals(expression.getRewardMethodFlag())) continue;
                Validate.notBlank((CharSequence)expression.getGiftCode(), (String)"\u8bf7\u9009\u62e9\u8d60\u54c1\uff01", (Object[])new Object[0]);
            }
            displayPolicyConfiguration.getDisplayPolicyExpressions().forEach(this::displayPolicyExpressionValidation);
        });
        displayPolicy.getUploadRules().forEach(this::displayUploadRulesValidation);
    }

    private void displayRangeValidation(DisplayPolicyRange displayPolicyRange) {
        Validate.notNull((Object)((Object)displayPolicyRange), (String)"\u4f20\u5165\u4fe1\u606f\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        displayPolicyRange.setId(null);
        Validate.notBlank((CharSequence)displayPolicyRange.getSpecialCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4ea7\u54c1\u7ef4\u5ea6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)displayPolicyRange.getSpecialName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4ea7\u54c1\u7ef4\u5ea6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void displayPolicyExpressionValidation(DisplayPolicyExpression displayPolicyExpression) {
        Validate.notNull((Object)((Object)displayPolicyExpression), (String)"\u4f20\u5165\u4fe1\u606f\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        displayPolicyExpression.setId(null);
        Validate.notBlank((CharSequence)displayPolicyExpression.getRewardMethodFlag(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5956\u52b1\u65b9\u5f0f\u6807\u5fd7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)displayPolicyExpression.getRewardMethodName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5956\u52b1\u65b9\u5f0f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)displayPolicyExpression.getDisplayNumber(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u9648\u5217\u9762\u8fbe\u6807\u4e2a\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)displayPolicyExpression.getRewardData(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5956\u52b1\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((displayPolicyExpression.getRewardData().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u5956\u52b1\u6570\u636e\u5fc5\u987b\u5927\u4e8e0\uff01", (Object[])new Object[0]);
    }

    private void displayUploadRulesValidation(DisplayPolicyUploadRule uploadRule) {
        Validate.notNull((Object)((Object)uploadRule), (String)"\u4f20\u5165\u4fe1\u606f\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        uploadRule.setId(null);
        Validate.notNull((Object)uploadRule.getOrderNum(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u9648\u5217\u7167\u4e0a\u4f20\u89c4\u5219\u6b21\u6570\u6807\u8bb0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((uploadRule.getOrderNum() > 0 ? 1 : 0) != 0, (String)"\u9648\u5217\u7167\u4e0a\u4f20\u89c4\u5219\u6b21\u6570\u6807\u8bb0\u5fc5\u987b\u5927\u4e8e0\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)uploadRule.getStartDay(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u9648\u5217\u7167\u4e0a\u4f20\u89c4\u5219\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((uploadRule.getStartDay() > 0 && uploadRule.getStartDay() < 32 ? 1 : 0) != 0, (String)"\u9648\u5217\u7167\u4e0a\u4f20\u89c4\u5219\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e0\u4e14\u5c0f\u4e8e32\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)uploadRule.getEndDay(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u9648\u5217\u7167\u4e0a\u4f20\u89c4\u5219\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((uploadRule.getEndDay() > uploadRule.getStartDay() && uploadRule.getEndDay() < 32 ? 1 : 0) != 0, (String)"\u9648\u5217\u7167\u4e0a\u4f20\u89c4\u5219\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u9648\u5217\u7167\u4e0a\u4f20\u89c4\u5219\u5f00\u59cb\u65f6\u95f4\u4e14\u5c0f\u4e8e32\uff01", (Object[])new Object[0]);
    }
}

