/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.display.ladder.service.observer;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.business.agreement.sdk.service.observer.AgreementPolicyInfoServiceObserver;
import com.biz.crm.cps.business.agreement.sdk.vo.TemplatePolicyRelationshipVo;
import com.biz.crm.cps.business.policy.display.ladder.entity.DisplayPolicy;
import com.biz.crm.cps.business.policy.display.ladder.entity.DisplayPolicyExpression;
import com.biz.crm.cps.business.policy.display.ladder.entity.DisplayPolicyRange;
import com.biz.crm.cps.business.policy.display.ladder.repository.DisplayPolicyExpressionRepository;
import com.biz.crm.cps.business.policy.display.ladder.repository.DisplayPolicyRepository;
import com.biz.crm.cps.business.product.sdk.service.MaterialVoService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AgreementDisplayInfoServiceObserverImpl
implements AgreementPolicyInfoServiceObserver {
    private static final Logger log = LoggerFactory.getLogger(AgreementDisplayInfoServiceObserverImpl.class);
    @Autowired
    private DisplayPolicyExpressionRepository displayPolicyExpressionRepository;
    @Autowired
    private DisplayPolicyRepository displayPolicyRepository;
    @Autowired
    private MaterialVoService materialVoService;

    public BigDecimal findNum(List<String> agreementIds, String displayDate, String rewardMethodFlag) {
        return this.displayPolicyExpressionRepository.findRewardDate(agreementIds, displayDate, rewardMethodFlag);
    }

    public TemplatePolicyRelationshipVo findPolicyInfoByTemplateCode(String templateCode) {
        DisplayPolicy displayPolicy = this.displayPolicyRepository.findDetailByTemplateCode(templateCode);
        if (Objects.nonNull((Object)displayPolicy)) {
            Set<DisplayPolicyRange> ranges;
            log.info("displayPolicy === {}", (Object)JSONObject.toJSONString((Object)((Object)displayPolicy)));
            TemplatePolicyRelationshipVo vo = new TemplatePolicyRelationshipVo();
            vo.setTemplateCode(templateCode);
            vo.setPolicyLadderCode(displayPolicy.getDisplayPolicyConfigurations().iterator().next().getAgreementLadderCode());
            Set<DisplayPolicyExpression> expressions = displayPolicy.getDisplayPolicyConfigurations().iterator().next().getDisplayPolicyExpressions();
            if (CollectionUtils.isNotEmpty(expressions)) {
                for (DisplayPolicyExpression expression : expressions) {
                    if (!"gift".equals(expression.getRewardMethodFlag())) continue;
                    vo.setGiftCode(expression.getGiftCode());
                }
            }
            if (!CollectionUtils.isEmpty(ranges = displayPolicy.getDisplayPolicyConfigurations().iterator().next().getDisplayPolicyRanges())) {
                ArrayList materialGroupCodes = Lists.newArrayList();
                for (DisplayPolicyRange range : ranges) {
                    materialGroupCodes.add(range.getSpecialCode());
                }
                List materialProductCodes = this.materialVoService.findMaterialProductCodesByDimensionCodesAndDimensionType((List)materialGroupCodes, displayPolicy.getDimensionFlag());
                vo.setMaterialProductCode(materialProductCodes);
            }
            return vo;
        }
        return null;
    }
}

