/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.display.ladder.service.observer;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementRelationActivityVoService;
import com.biz.crm.cps.business.common.sdk.enums.SendEnum;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.vo.LoginUserDetails;
import com.biz.crm.cps.business.policy.display.ladder.entity.DisplayCalculateTask;
import com.biz.crm.cps.business.policy.display.ladder.entity.DisplayPolicy;
import com.biz.crm.cps.business.policy.display.ladder.entity.DisplayPolicyRange;
import com.biz.crm.cps.business.policy.display.ladder.repository.DisplayCalculateTaskRepository;
import com.biz.crm.cps.business.policy.display.ladder.repository.DisplayTaskUploadRepository;
import com.biz.crm.cps.business.policy.display.ladder.service.DisplayPolicyService;
import com.biz.crm.cps.business.product.sdk.service.MaterialVoService;
import com.biz.crm.cps.business.product.sdk.vo.MaterialVo;
import com.biz.crm.cps.business.reward.gift.sdk.service.observer.RewardGiftPolicyObserver;
import com.biz.crm.cps.external.feign.service.CpsSfaFeign;
import com.biz.crm.nebular.sfa.activity.req.CpsActivityItemQueryReqVo;
import com.biz.crm.nebular.sfa.activity.req.CpsDisplayFeeCreateReqVo;
import com.biz.crm.nebular.sfa.activity.req.DisplayFeeProductVo;
import com.biz.crm.nebular.sfa.activity.resp.CpsActivityItemQueryRespVo;
import com.biz.crm.util.Result;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DisplayPolicyRewardGiftObserverImpl
implements RewardGiftPolicyObserver {
    private static final Logger log = LoggerFactory.getLogger(DisplayPolicyRewardGiftObserverImpl.class);
    @Autowired
    private AgreementRelationActivityVoService agreementRelationActivityVoService;
    @Autowired
    private DisplayCalculateTaskRepository displayCalculateTaskRepository;
    @Autowired
    private DisplayTaskUploadRepository displayTaskUploadRepository;
    @Autowired
    private DisplayPolicyService displayPolicyService;
    @Autowired
    private MaterialVoService materialVoService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private CpsSfaFeign cpsSfaFeign;

    public void sendToSfa(String business, BigDecimal amount, String address, List<String> imgs) {
        log.info("\u9648\u5217\u8d44\u6e90\u63a8\u9001SFA-business={},amount={}", (Object)business, (Object)amount);
        DisplayCalculateTask displayTask = this.displayCalculateTaskRepository.findByBusinessCode(business);
        if (Objects.isNull((Object)displayTask)) {
            return;
        }
        displayTask.setAddress(address);
        this.sendSfa(displayTask, imgs, amount, true);
    }

    public void sendSfa(DisplayCalculateTask displayTask, List<String> imgs, BigDecimal amount, boolean isExecuteComplete) {
        LoginUserDetails loginUserDetails = this.loginUserService.getLoginUser();
        if (Objects.isNull(loginUserDetails)) {
            return;
        }
        Date now = new Date();
        DisplayPolicy displayPolicy = this.displayPolicyService.findById(displayTask.getDisplayPolicyId());
        List actCodes = this.agreementRelationActivityVoService.findActCodesByAgreementId(displayTask.getAgreementId());
        if (!CollectionUtils.isEmpty((Collection)actCodes)) {
            for (String actCode : actCodes) {
                CpsActivityItemQueryRespVo act;
                CpsActivityItemQueryReqVo dto = new CpsActivityItemQueryReqVo();
                dto.setActivityItemCode(actCode);
                dto.setUserPosCode(loginUserDetails.getPostCode());
                Result actResult = this.cpsSfaFeign.cpsActivityItemQuery(dto);
                log.info("\u67e5\u8be2\u6d3b\u52a8\u4fe1\u606f\u8fd4\u56de={}", (Object)JSONObject.toJSONString((Object)actResult));
                if (!Objects.nonNull(actResult) || !actResult.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)actResult.getResult())) || !now.before((act = (CpsActivityItemQueryRespVo)((List)actResult.getResult()).get(0)).getEndTime()) || !now.after(act.getStartTime())) continue;
                CpsDisplayFeeCreateReqVo req = new CpsDisplayFeeCreateReqVo();
                req.setActivityItemCode(actCode);
                req.setPhotoTime(new Date());
                req.setUserCode(loginUserDetails.getAccount());
                req.setUserName(this.loginUserService.getLoginAccountName());
                req.setUserPosCode(loginUserDetails.getPostCode());
                req.setUserPosName(loginUserDetails.getPostName());
                req.setExecuteAddress(displayTask.getAddress());
                req.setTerminalCode(displayTask.getTerminalCode());
                req.setTerminalName(displayTask.getTerminalName());
                req.setStartTime(act.getStartTime());
                req.setEndTime(act.getEndTime());
                req.setDisplayLadder(displayPolicy.getDisplayPolicyConfigurations().iterator().next().getDisplayNumber().toString());
                if (Objects.nonNull(amount) && amount.compareTo(new BigDecimal(0)) == 1) {
                    req.setTotalAmount(amount.multiply(act.getHonourProductPrice()));
                } else {
                    req.setTotalAmount(new BigDecimal(0));
                }
                ArrayList specialCodes = Lists.newArrayList();
                for (DisplayPolicyRange range : displayPolicy.getDisplayPolicyConfigurations().iterator().next().getDisplayPolicyRanges()) {
                    specialCodes.add(range.getSpecialCode());
                }
                List materialVos = this.materialVoService.findMaterialDimensionCodesAndDimensionType((List)specialCodes, displayPolicy.getDimensionFlag());
                ArrayList products = Lists.newArrayList();
                if (!CollectionUtils.isEmpty((Collection)materialVos)) {
                    for (MaterialVo materialVo : materialVos) {
                        DisplayFeeProductVo productVo = new DisplayFeeProductVo();
                        productVo.setProductCode(materialVo.getMaterialCode());
                        productVo.setProductName(materialVo.getMaterialName());
                        products.add(productVo);
                    }
                }
                req.setProducts((List)products);
                ArrayList doorPhotos = Lists.newArrayList();
                ArrayList displayPhotos = Lists.newArrayList();
                if (!CollectionUtils.isEmpty(imgs)) {
                    doorPhotos.add(imgs.get(0));
                    displayPhotos.addAll(imgs);
                }
                req.setDoorPhotos((List)doorPhotos);
                req.setDisplayPhotos((List)displayPhotos);
                req.setIsExecuteComplete(Boolean.valueOf(isExecuteComplete));
                log.info("\u9648\u5217\u8d44\u6e90\u63a8\u9001SFA\u5165\u53c2={}", (Object)JSONObject.toJSONString((Object)req));
                Result result = this.cpsSfaFeign.cpsCreateDisplayFee(req);
                log.info("\u9648\u5217\u8d44\u6e90\u63a8\u9001SFA\u8fd4\u56de={}", (Object)JSONObject.toJSONString((Object)result));
                if (!Objects.nonNull(result) || !result.isSuccess()) continue;
                displayTask.setSendSfa(SendEnum.YES.getCode());
                this.displayCalculateTaskRepository.updateById((Object)displayTask);
            }
        }
    }
}

