/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.display.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.bisiness.policy.display.sdk.common.constant.DisplayConstant;
import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.AuditResultEnum;
import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.BindStatusEnum;
import com.biz.crm.cps.bisiness.policy.display.sdk.common.enums.DisplayTaskStatusEnum;
import com.biz.crm.cps.bisiness.policy.display.sdk.dto.DisplayTaskDto;
import com.biz.crm.cps.bisiness.policy.display.sdk.dto.DisplayTaskUploadInfoDto;
import com.biz.crm.cps.business.agreement.sdk.common.enums.AutoSignEnum;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementDto;
import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.policy.display.local.entity.DisplayPolicy;
import com.biz.crm.cps.business.policy.display.local.entity.DisplayPolicyExpression;
import com.biz.crm.cps.business.policy.display.local.entity.DisplayPolicyRange;
import com.biz.crm.cps.business.policy.display.local.entity.DisplayTask;
import com.biz.crm.cps.business.policy.display.local.entity.DisplayTaskDetail;
import com.biz.crm.cps.business.policy.display.local.entity.DisplayTaskUpload;
import com.biz.crm.cps.business.policy.display.local.repository.DisplayTaskDetailRepository;
import com.biz.crm.cps.business.policy.display.local.repository.DisplayTaskRepository;
import com.biz.crm.cps.business.policy.display.local.repository.DisplayTaskUploadRepository;
import com.biz.crm.cps.business.policy.display.local.service.DisplayPolicyService;
import com.biz.crm.cps.business.policy.display.local.service.DisplayTaskService;
import com.biz.crm.cps.business.policy.display.local.service.builder.DisplayTaskDefaultBuilder;
import com.biz.crm.cps.business.policy.display.local.utils.DisplaySchedulerUtils;
import com.biz.crm.cps.business.policy.sdk.dto.PolicyRewardConditionDto;
import com.biz.crm.cps.business.policy.sdk.service.observer.PolicyRewardServiceObserver;
import com.biz.crm.cps.business.product.sdk.service.MaterialVoService;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordStatisticsDto;
import com.biz.crm.cps.external.barcode.sdk.service.ScanCodeRecordVoService;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.bizunited.platform.task.annotations.DynamicTaskService;
import com.bizunited.platform.task.service.DynamicTaskSchedulerVoService;
import com.bizunited.platform.task.vo.DynamicTaskSchedulerVo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="displayTaskServiceImpl")
public class DisplayTaskServiceImpl
implements DisplayTaskService {
    @Autowired
    private AgreementVoService agreementVoService;
    @Autowired
    private DisplayPolicyService displayPolicyService;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private DisplayTaskRepository displayTaskRepository;
    @Autowired
    private ScanCodeRecordVoService scanCodeRecordVoService;
    @Autowired
    private MaterialVoService materialVoService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private List<PolicyRewardServiceObserver> policyRewardServiceObservers;
    @Autowired
    private DisplayTaskDetailRepository displayTaskDetailRepository;
    @Autowired
    private DynamicTaskSchedulerVoService dynamicTaskSchedulerVoService;
    @Autowired
    private DisplayTaskUploadRepository displayTaskUploadRepository;

    @Override
    @Transactional
    public List<DisplayTask> create(String agreementId) {
        LoginUserAgreementDto loginUserAgreementDto = new LoginUserAgreementDto();
        loginUserAgreementDto.setAgreementCode(agreementId);
        AgreementDto agreementDto = new AgreementDto();
        agreementDto.setAgreementCode(agreementId);
        Page agreementVo = this.agreementVoService.findByConditions((Pageable)PageRequest.of((int)0, (int)50), agreementDto);
        if (agreementVo != null && !CollectionUtils.isEmpty((Collection)agreementVo.getRecords())) {
            return this.create((AgreementVo)agreementVo.getRecords().get(0));
        }
        return Lists.newArrayList();
    }

    @Override
    @Transactional
    public List<DisplayTask> create(AgreementVo agreementVo) {
        DisplayPolicy displayPolicy = this.displayPolicyService.findByTemplateCode(agreementVo.getTemplateCode());
        Validate.notNull((Object)((Object)displayPolicy), (String)("\u534f\u8bae\u6a21\u677f\u7f16\u7801" + agreementVo.getAgreementCode() + "\u672a\u627e\u5230\u5bf9\u5e94\u7684\u9648\u5217\u653f\u7b56\uff01"), (Object[])new Object[0]);
        DisplayTaskDefaultBuilder displayTaskBuilder = new DisplayTaskDefaultBuilder();
        List<DisplayTask> taskList = displayTaskBuilder.handleAssemblyDisplayTask(agreementVo, displayPolicy);
        if (!CollectionUtils.isEmpty(taskList)) {
            List businessCodes = this.generateCodeService.generateCode("display_task_code", taskList.size());
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)businessCodes) && businessCodes.size() == taskList.size() ? 1 : 0) != 0, (String)"\u751f\u6210\u4e1a\u52a1\u5355\u53f7\u5f02\u5e38", (Object[])new Object[0]);
            String tenantCode = TenantUtils.getTenantCode();
            for (int i = 0; i < taskList.size(); ++i) {
                taskList.get(i).setBusinessCode((String)businessCodes.get(i));
                taskList.get(i).setDisplayPolicyId(displayPolicy.getId());
                taskList.get(i).setAgreementId(agreementVo.getAgreementCode());
                taskList.get(i).setAgreementName(agreementVo.getAgreementName());
                taskList.get(i).setTemplateId(agreementVo.getTemplateCode());
                taskList.get(i).setTemplateName(agreementVo.getBelongTemplate());
                taskList.get(i).setTerminalCode(agreementVo.getTerminalCode());
                taskList.get(i).setTerminalName(agreementVo.getRelationTerminal());
                taskList.get(i).setUploadPictureNumber(0);
                taskList.get(i).setTenantCode(tenantCode);
            }
        }
        this.displayTaskRepository.saveBatch(taskList);
        taskList.forEach(task -> {
            String schedulerCron = DisplaySchedulerUtils.getSchedulerCron(task.getTaskEndTime());
            Date endTime = DateUtils.addDays((Date)DateUtils.ceiling((Date)task.getTaskEndTime(), (int)2), (int)1);
            DynamicTaskSchedulerVo taskSchedulerVo = this.dynamicTaskSchedulerVoService.createIgnorePrefix(task.getBusinessCode(), "displayTaskServiceImpl", "handleSettlementTask", schedulerCron, endTime, task.getTaskName(), new Object[]{task.getBusinessCode()});
            this.dynamicTaskSchedulerVoService.start(new String[]{taskSchedulerVo.getTaskCode()});
        });
        return taskList;
    }

    @Override
    @DynamicTaskService(cornExpression="0 0 0 * * ?", taskDesc="\u542f\u52a8/\u5173\u95ed\u9648\u5217\u4efb\u52a1")
    public void handleDisplayTask() {
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        int nowDay = calendar.get(5);
        Date startTime = DateUtils.ceiling((Date)DateUtils.setDays((Date)now, (int)(nowDay - 1)), (int)5);
        this.startDisplayTaskBatch(startTime);
        Date endTime = DateUtils.addSeconds((Date)DateUtils.ceiling((Date)now, (int)5), (int)-1);
        this.closeDisplayTaskBatch(endTime);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void handleSettlementTask(String businessCode) {
        DisplayTask displayTask = this.displayTaskRepository.findByBusinessCode(businessCode);
        Validate.notNull((Object)((Object)displayTask), (String)("\u4e1a\u52a1\u5355\u53f7\uff1a" + businessCode + "\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u9648\u5217\u4efb\u52a1\uff01"), (Object[])new Object[0]);
        DisplayPolicy displayPolicy = this.displayPolicyService.findByTemplateCode(displayTask.getTemplateId());
        Validate.notNull((Object)((Object)displayPolicy), (String)("\u4e1a\u52a1\u5355\u53f7\uff1a" + businessCode + "\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u9648\u5217\u653f\u7b56\uff01"), (Object[])new Object[0]);
        List<DisplayTaskDetail> displayTaskDetails = this.buildTaskDetail(displayPolicy, displayTask);
        this.sendToCost(displayTask, displayTaskDetails);
        this.updateQuantifyTask(displayTask, displayTaskDetails);
        if (!CollectionUtils.isEmpty(displayTaskDetails)) {
            this.displayTaskDetailRepository.saveBatch(displayTaskDetails);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateTaskStatus(DisplayTaskDto displayTaskDto) {
        Validate.notNull((Object)displayTaskDto, (String)"\u63d0\u4ea4\u4efb\u52a1\u5ba1\u6838\u65f6\uff0c\u4f20\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)displayTaskDto.getBusinessCode());
        Validate.notBlank((CharSequence)displayTaskDto.getFinalAuditResult());
        DisplayTask displayTask = this.displayTaskRepository.findByBusinessCode(displayTaskDto.getBusinessCode());
        Validate.notNull((Object)((Object)displayTask), (String)"\u8be5\u4efb\u52a1\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        displayTask.setFinalAuditResult(displayTaskDto.getFinalAuditResult());
        displayTask.setRemark(displayTaskDto.getRemark());
        if (AuditResultEnum.QUALIFIED.getDictCode().equals(displayTask.getFinalAuditResult())) {
            displayTask.setTaskStatus(DisplayTaskStatusEnum.STATUS_PASS.getDictCode());
        } else {
            displayTask.setTaskStatus(DisplayTaskStatusEnum.STATUS_NOT_PASS.getDictCode());
        }
        this.displayTaskRepository.updateById((Object)displayTask);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void handleSubmitDisplayTask(DisplayTaskUploadInfoDto displayTaskUploadInfoDto) {
        Validate.notNull((Object)displayTaskUploadInfoDto, (String)"\u4f20\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)displayTaskUploadInfoDto.getBusinessCode(), (String)"\u4f20\u5165\u4e1a\u52a1\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)displayTaskUploadInfoDto.getUploadNumber(), (String)"\u4e0a\u4f20\u56fe\u7247\u6b21\u6570(\u7b2c\u51e0\u6b21)\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)displayTaskUploadInfoDto.getDisplayTaskUploads()) ? 1 : 0) != 0, (String)"\u4e0a\u4f20\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        DisplayTask displayTask = this.displayTaskRepository.findByBusinessCode(displayTaskUploadInfoDto.getBusinessCode());
        Validate.notNull((Object)((Object)displayTask), (String)"\u8be5\u4efb\u52a1\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        displayTask.setUploadPictureNumber(displayTaskUploadInfoDto.getUploadNumber());
        ArrayList displayTaskUploads = Lists.newArrayList();
        Date now = new Date();
        displayTaskUploadInfoDto.getDisplayTaskUploads().forEach(displayTaskUploadDto -> {
            DisplayTaskUpload displayTaskUpload = new DisplayTaskUpload();
            displayTaskUpload.setCreateTime(now);
            displayTaskUpload.setBusinessCode(displayTask.getBusinessCode());
            displayTaskUpload.setUploadNumber(displayTask.getUploadPictureNumber());
            displayTaskUpload.setPictureUrl(displayTaskUploadDto.getPictureUrl());
            displayTaskUpload.setPictureSerialNumber(displayTaskUploadDto.getPictureSerialNumber());
            displayTaskUploads.add(displayTaskUpload);
        });
        this.displayTaskRepository.updateById((Object)displayTask);
        this.displayTaskUploadRepository.saveBatch(displayTaskUploads);
        this.handleAiAudit(displayTask);
    }

    private void handleAiAudit(DisplayTask displayTask) {
        if (displayTask == null) {
            return;
        }
        int max = 100;
        int min = 1;
        int rand = (int)(Math.random() * (double)(max - min) + (double)min);
        if (rand % 2 == 0) {
            displayTask.setAiAuditResult(AuditResultEnum.QUALIFIED.getDictCode());
            displayTask.setTaskStatus(DisplayTaskStatusEnum.STATUS_PASS.getDictCode());
        } else if (DisplayTaskStatusEnum.STATUS_AI_REJECT.getDictCode().equals(displayTask.getTaskStatus())) {
            displayTask.setAiAuditResult(AuditResultEnum.REJECT.getDictCode());
            displayTask.setTaskStatus(DisplayTaskStatusEnum.STATUS_MANUALLY_REVIEW.getDictCode());
        } else {
            displayTask.setAiAuditResult(AuditResultEnum.REJECT.getDictCode());
            displayTask.setTaskStatus(DisplayTaskStatusEnum.STATUS_AI_REJECT.getDictCode());
        }
        this.displayTaskRepository.updateById((Object)displayTask);
    }

    private void startDisplayTaskBatch(Date startTime) {
        if (startTime == null) {
            return;
        }
        DisplayTaskDto displayTaskDto = new DisplayTaskDto();
        displayTaskDto.setTaskStartTime(startTime);
        displayTaskDto.setTaskStatus(DisplayTaskStatusEnum.STATUS_NOT_BEGIN.getDictCode());
        List<DisplayTask> displayTasks = this.displayTaskRepository.findByConditions(displayTaskDto);
        displayTasks.forEach(displayTask -> displayTask.setTaskStatus(DisplayTaskStatusEnum.STATUS_WAIT.getDictCode()));
        this.displayTaskRepository.updateBatchById(displayTasks);
    }

    private void closeDisplayTaskBatch(Date endTime) {
        if (endTime == null) {
            return;
        }
        DisplayTaskDto displayTaskDto = new DisplayTaskDto();
        displayTaskDto.setTaskEndTime(endTime);
        displayTaskDto.setTaskStatus(DisplayTaskStatusEnum.STATUS_WAIT.getDictCode());
        List<DisplayTask> displayTasks = this.displayTaskRepository.findByConditions(displayTaskDto);
        displayTasks.forEach(displayTask -> displayTask.setTaskStatus(DisplayTaskStatusEnum.STATUS_OVERDUE.getDictCode()));
        displayTaskDto.setTaskStatus(DisplayTaskStatusEnum.STATUS_AI_REJECT.getDictCode());
        List<DisplayTask> statusAiRejectTasks = this.displayTaskRepository.findByConditions(displayTaskDto);
        List collect = statusAiRejectTasks.stream().filter(displayTask -> {
            if (DisplayConstant.SECONDARY_TO_SUBMIT.intValue() == displayTask.getUploadPictureNumber().intValue()) {
                displayTask.setTaskStatus(DisplayTaskStatusEnum.STATUS_PASS.getDictCode());
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        displayTasks.addAll(collect);
        this.displayTaskRepository.updateBatchById(displayTasks);
    }

    private List<DisplayTaskDetail> buildTaskDetail(DisplayPolicy displayPolicy, DisplayTask displayTask) {
        if (!DisplayTaskStatusEnum.STATUS_PASS.getDictCode().equals(displayTask.getTaskStatus())) {
            return null;
        }
        ArrayList quantifyTaskDetails = Lists.newArrayList();
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        Date settlementEndTime = DateUtils.addSeconds((Date)DateUtils.addMonths((Date)DateUtils.ceiling((Date)now, (int)2), (int)-1), (int)-1);
        Date settlementStartTime = DateUtils.addMonths((Date)DateUtils.ceiling((Date)now, (int)2), (int)-2);
        displayPolicy.getDisplayPolicyConfigurations().forEach(configuration -> {
            int scanCount = 0;
            if (BindStatusEnum.YES.getDictCode().equals(displayPolicy.getBindSaleStatus())) {
                ScanCodeRecordStatisticsDto scanCodeRecordStatisticsDto = new ScanCodeRecordStatisticsDto();
                scanCodeRecordStatisticsDto.setCreateTimeStart(settlementStartTime);
                scanCodeRecordStatisticsDto.setCreateTimeEnd(settlementEndTime);
                scanCodeRecordStatisticsDto.setScanParticipatorCode(displayTask.getTerminalCode());
                if ("DIMENSION_ALL".equals(configuration.getDimensionFlag())) {
                    scanCodeRecordStatisticsDto.setMaterialCodes((List)Lists.newArrayList());
                    scanCount = this.scanCodeRecordVoService.countByScanCodeRecordDto(scanCodeRecordStatisticsDto);
                } else {
                    List dimensionCodes = configuration.getDisplayPolicyRanges().stream().map(DisplayPolicyRange::getSpecialCode).collect(Collectors.toList());
                    List materialCodes = this.materialVoService.findMaterialCodeByDimensionCodesAndDimensionType(dimensionCodes, configuration.getDimensionFlag());
                    if (!CollectionUtils.isEmpty((Collection)materialCodes)) {
                        scanCodeRecordStatisticsDto.setMaterialCodes(materialCodes);
                        scanCount = this.scanCodeRecordVoService.countByScanCodeRecordDto(scanCodeRecordStatisticsDto);
                    }
                }
            }
            for (DisplayPolicyExpression expression : configuration.getDisplayPolicyExpressions()) {
                DisplayTaskDetail displayTaskDetail = (DisplayTaskDetail)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)expression, DisplayTaskDetail.class, Set.class, ArrayList.class, new String[0])));
                displayTaskDetail.setId(null);
                displayTaskDetail.setBusinessCode(displayTask.getBusinessCode());
                displayTaskDetail.setSaleTarget(displayTask.getSaleTarget());
                displayTaskDetail.setActualSales(new BigDecimal(scanCount));
                displayTaskDetail.setProfitStatus(displayTaskDetail.getActualSales().compareTo(displayTaskDetail.getSaleTarget()) > -1 ? AutoSignEnum.YES.getCode() : AutoSignEnum.NO.getCode());
                quantifyTaskDetails.add(displayTaskDetail);
            }
        });
        return quantifyTaskDetails;
    }

    private void sendToCost(DisplayTask displayTask, List<DisplayTaskDetail> displayTaskDetails) {
        if (CollectionUtils.isEmpty(displayTaskDetails)) {
            return;
        }
        ArrayList policyRewardConditionDtos = Lists.newArrayList();
        displayTaskDetails.forEach(detail -> {
            if (AutoSignEnum.YES.getCode().equals(detail.getProfitStatus())) {
                PolicyRewardConditionDto policyRewardConditionDto = new PolicyRewardConditionDto();
                policyRewardConditionDto.setActualParticipatorFlag(ParticipatorTypeEnum.TERMINAL.getDictCode());
                policyRewardConditionDto.setActualParticipatorCode(displayTask.getTerminalCode());
                policyRewardConditionDto.setRewardMethodFlag(detail.getRewardMethodFlag());
                policyRewardConditionDto.setRewardMethodName(detail.getRewardMethodName());
                policyRewardConditionDto.setAwardConditionFlag(detail.getAwardConditionFlag());
                policyRewardConditionDto.setAwardConditionName(detail.getAwardConditionName());
                policyRewardConditionDto.setRewardData(detail.getRewardData().toString());
                policyRewardConditionDto.setTriggerAction("display");
                policyRewardConditionDto.setTriggerObject(displayTask.getBusinessCode());
                policyRewardConditionDto.setAgreementCode(displayTask.getAgreementId());
            }
        });
        if (!CollectionUtils.isEmpty((Collection)policyRewardConditionDtos) && !CollectionUtils.isEmpty(this.policyRewardServiceObservers)) {
            this.policyRewardServiceObservers.forEach(policyRewardServiceObserver -> policyRewardServiceObserver.createRewardRecord(policyRewardConditionDtos));
        }
    }

    private void updateQuantifyTask(DisplayTask displayTask, List<DisplayTaskDetail> displayTaskDetails) {
        if (CollectionUtils.isEmpty(displayTaskDetails)) {
            return;
        }
        displayTask.setTaskStatus(DisplayTaskStatusEnum.STATUS_COMPLETE.getDictCode());
        this.displayTaskRepository.updateById((Object)displayTask);
    }
}

