package com.biz.crm.cps.business.policy.local.controller;

import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.policy.local.service.TriggerActionMountService;
import com.biz.crm.cps.external.mdm.sdk.vo.DictVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collection;

/**
 * 触发动作挂载的接口
 * @author hefan
 */
@Api(tags = "分利终端信息")
@Slf4j
@RestController
@RequestMapping("/v1/policy/action")
public class TriggerActionMountController {

  @Autowired
  private TriggerActionMountService triggerActionMountService;

  /**
   * 查询系统内挂载的触发动作信息
   */
  @ApiOperation(value = "查询系统内挂载的触发动作信息")
  @GetMapping(value = "/find")
  public Result<Collection<DictVo>> find() {
    try {
      Collection<DictVo> current = this.triggerActionMountService.find();
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
