package com.biz.crm.cps.business.policy.local.service.internal;

import com.biz.crm.cps.business.policy.local.service.TriggerActionMountService;
import com.biz.crm.cps.business.policy.sdk.service.observer.TriggerActionMountObserver;
import com.biz.crm.cps.external.mdm.sdk.vo.DictVo;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.List;

/**
 * 触发动作挂载service实现类
 * @author hefan
 */
@Service
public class TriggerActionMountServiceImpl implements TriggerActionMountService {

  @Autowired(required = false)
  private List<TriggerActionMountObserver> triggerActionMountObserverList;

  @Override
  public Collection<DictVo> find() {
    List<DictVo> list = Lists.newLinkedList();
    if (!CollectionUtils.isEmpty(this.triggerActionMountObserverList)) {
      for (TriggerActionMountObserver observer : this.triggerActionMountObserverList) {
        Collection<DictVo> dictVos = observer.find();
        list.addAll(dictVos);
      }
    }
    return list;
  }
}
