package com.biz.crm.cps.business.policy.quantify.fiscal.local.controller;

import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyPolicy;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.service.QuantifyPolicyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author jerry7
 * @date 2021/8/13 9:38
 */
@Slf4j
@RestController
@RequestMapping("/v1/quantify/policy")
@Api(tags = "包量政策相关接口")
public class QuantifyPolicyController {

  @Autowired
  private QuantifyPolicyService quantifyPolicyService;

  @ApiOperation(value = "创建包量政策")
  @PostMapping("")
  public Result<QuantifyPolicy> create(@RequestBody QuantifyPolicy quantifyPolicy) {
    try {
      QuantifyPolicy policy = quantifyPolicyService.createFrom(quantifyPolicy);
      return Result.ok(policy);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "根据id查询包量政策详情")
  @GetMapping("/{id}")
  public Result<QuantifyPolicy> findById(@PathVariable("id") String id) {
    try {
      QuantifyPolicy policy = quantifyPolicyService.findById(id);
      return Result.ok(policy);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
