package com.biz.crm.cps.business.policy.quantify.fiscal.local.controller;

import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.service.QuantifyStatisticsTaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 包量任务统计
 * @Author: zengxingwang
 * @Date: 2021/11/23 16:34
 */
@Api(tags = "包量任务统计")
@Slf4j
@RestController
@RequestMapping("/v1/web/quantifyStatisticsTask")
public class QuantifyStatisticsTaskController {

  @Autowired
  private QuantifyStatisticsTaskService quantifyStatisticsTaskService;
  /**
   * 包量任务实际量统计(手动触发)
   * @return
   */
  @ApiOperation(value = "包量任务实际量统计(手动触发)")
  @GetMapping(value = "/triggerTask")
  public Result<?> triggerTask() {
    try {
      quantifyStatisticsTaskService.triggerTask();
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
