package com.biz.crm.cps.business.policy.quantify.fiscal.local.controller;

import com.biz.crm.cps.bisiness.policy.quantify.sdk.service.ScanCodeQuantityTaskVoService;
import com.biz.crm.cps.bisiness.policy.quantify.sdk.vo.ScanCodeQuantityTaskVo;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 包量任务扫码相关接口
 *
 * @author sunx
 * @date 2021/12/9
 */
@Slf4j
@RestController
@RequestMapping("/v1/quantify/task/scanCode")
@Api(tags = "包量任务扫码相关接口")
public class ScanCodeQuantityTaskVoController {
  @Autowired private ScanCodeQuantityTaskVoService scanCodeQuantityTaskVoService;

  @ApiOperation(value = "获取终端扫码任务完成情况")
  @GetMapping("findScanCodeQuantityTaskVoList")
  public Result<List<ScanCodeQuantityTaskVo>> findScanCodeQuantityTaskVoList() {
    try {
      List<ScanCodeQuantityTaskVo> list =
          scanCodeQuantityTaskVoService.findScanCodeQuantityTaskVoList();
      return Result.ok(list);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
