package com.biz.crm.cps.business.policy.quantify.fiscal.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.util.Set;

/**
 * @author jerry7
 * @date 2021/8/7 16:02
 * 包量政策配置
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "QuantifyConfiguration", description = "包量政策配置行")
@TableName("fiscal_quantify_configuration")
public class QuantifyConfiguration extends BaseIdEntity {
  
  private static final long serialVersionUID = -6975595289067993485L;

  /**
   * 包量政策配置id
   */
  @ApiModelProperty("包量政策id")
  @TableField(value = "quantify_policy_id")
  @Column(name = "quantify_policy_id", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 包量政策id '")
  private String quantifyPolicyId;

  /**
   * 协议阶梯编码
   */
  @ApiModelProperty("协议阶梯编码")
  @TableField(value = "agreement_ladder_code")
  @Column(name = "agreement_ladder_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 协议阶梯编码 '")
  private String agreementLadderCode;

  /**
   * 是否只使用最高级别返利(Y/N)
   */
  @ApiModelProperty("是否只使用最高级别返利(Y/N)")
  @TableField(value = "only_highest_level")
  @Column(name = "only_highest_level", nullable = false, length = 2, columnDefinition = "VARCHAR(64) COMMENT ' 是否只使用最高级别返利(Y/N) '")
  private String onlyHighestLevel;

  /**
   * 配置关联产品维度列表
   */
  @ApiModelProperty("配置关联产品维度")
  @TableField(exist = false)
  private Set<QuantifyRange> quantifyRanges;

  /**
   * 配置关联分利表达式列表
   */
  @ApiModelProperty("配置关联分利表达式列表")
  @TableField(exist = false)
  private Set<QuantifyExpression> quantifyExpressions;
}
