package com.biz.crm.cps.business.policy.quantify.fiscal.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bizunited.nebula.common.entity.UuidEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * 包量任务财年配置
 * @Author: zengxingwang
 * @Date: 2021/11/10 15:41
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "QuantifyFiscal", description = "包量任务财年配置")
@TableName("quantify_fiscal")
public class QuantifyFiscal extends UuidEntity {

  /**
   * 包量政策配置id
   */
  @ApiModelProperty("包量政策id")
  @TableField(value = "quantify_policy_id")
  @Column(name = "quantify_policy_id", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 包量政策id '")
  private String quantifyPolicyId;

  /**
   * 财年月
   */
  @ApiModelProperty("财年月")
  @TableField(value = "fiscal_month")
  @Column(name = "fiscal_month", columnDefinition = "int(1) COMMENT ' 财年月 '")
  private Integer fiscalMonth;

  /**
   * 自然月
   */
  @ApiModelProperty("自然月")
  @TableField(value = "nature_year_month")
  @Column(name = "nature_year_month", length = 64, columnDefinition = "VARCHAR(255) COMMENT ' 自然月 '")
  private String natureYearMonth;
}
