package com.biz.crm.cps.business.policy.quantify.fiscal.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.util.List;
import java.util.Set;

/**
 * @author jerry7
 * @date 2021/8/7 16:46
 * 包量政策实体
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "QuantifyPolicy", description = "包量政策实体")
@TableName("fiscal_quantify_policy")
public class QuantifyPolicy extends TenantOpEntity {
  
  private static final long serialVersionUID = -4979482354738454714L;

  /**
   * 模板编码
   */
  @ApiModelProperty("模板编码")
  @TableField(value = "template_code")
  @Column(name = "template_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 协议模板id '")
  private String templateCode;

  /**
   * 扫码产品维度标识
   */
  @ApiModelProperty("扫码产品维度标识")
  @TableField(value = "dimension_flag")
  @Column(name = "dimension_flag", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 扫码产品维度标识 '")
  private String dimensionFlag;

  /**
   * 扫码产品维度名称
   */
  @ApiModelProperty("扫码产品维度名称")
  @TableField(value = "dimension_name")
  @Column(name = "dimension_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 扫码产品维度名称 '")
  private String dimensionName;

  /**
   * 政策关联配置列表
   */
  @ApiModelProperty("政策关联配置列表")
  @TableField(exist = false)
  private Set<QuantifyConfiguration> quantifyConfigurations;

  /**
   * 奖励周期类型(1:自然年/2:财年)
   */
  @ApiModelProperty("奖励周期类型(1:自然年/2:财年) ")
  @TableField(value = "reward_cycle_type")
  @Column(name = "reward_cycle_type", nullable = false, length = 2, columnDefinition = "VARCHAR(64) COMMENT ' 奖励周期类型(1:自然年/2:财年) '")
  private String rewardCycleType;

  /**
   * 财年
   */
  @ApiModelProperty("财年")
  @TableField(value = "fiscal")
  @Column(name = "fiscal", columnDefinition = "VARCHAR(64) COMMENT ' 财年'")
  private String fiscal;

  /**
   * 财年信息
   */
  @ApiModelProperty("财年信息")
  @TableField(exist = false)
  private List<QuantifyFiscal> quantifyFiscals;
}
