package com.biz.crm.cps.business.policy.quantify.fiscal.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bizunited.nebula.common.entity.UuidEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/** 包量统计信息 @Author: zengxingwang @Date: 2021/11/24 14:27 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "QuantifyStatistics", description = "包量统计信息")
@TableName("fiscal_quantify_statistics")
public class QuantifyStatistics extends UuidEntity {

  /** 业务单号(生成包量任务时生成) */
  @ApiModelProperty("业务单号")
  @TableField(value = "business_code")
  @Column(
      name = "business_code",
      nullable = false,
      length = 64,
      columnDefinition = "VARCHAR(64) COMMENT ' 业务单号 '")
  private String businessCode;

  /** 数量 */
  @ApiModelProperty("数量")
  @TableField(value = "amount")
  private BigDecimal amount;

  /** 条码 */
  @ApiModelProperty("条码")
  @TableField(value = "bar_code")
  @Column(
      name = "bar_code",
      nullable = false,
      length = 64,
      columnDefinition = "VARCHAR(64) COMMENT ' 条码 '")
  private String barCode;

  /** 商品编码 */
  @ApiModelProperty("商品编码")
  @TableField(value = "product_code")
  @Column(
      name = "product_code",
      nullable = false,
      length = 64,
      columnDefinition = "VARCHAR(64) COMMENT ' 商品编码 '")
  private String productCode;

  /**
   * 创建时间 @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT
   * '创建时间'")
   */
  @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTime;

  /**
   * 租户编号 @Column(name = "tenant_code", nullable = false, columnDefinition = "varchar(64) COMMENT
   * '租户编号'")
   */
  @ApiModelProperty(name = "tenantCode", value = "租户编号", required = true)
  @TableField(value = "tenant_code")
  private String tenantCode;
}
