package com.biz.crm.cps.business.policy.quantify.fiscal.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * @author jerry7
 * @date 2021/8/7 16:08
 * 包量政策任务结算详情
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "QuantifyTaskDetail", description = "包量政策任务分利详情")
@TableName("fiscal_quantify_task_detail")
public class QuantifyTaskDetail extends QuantifyExpression {
  
  private static final long serialVersionUID = 1753856760216612271L;

  /**
   * 业务单号(生成包量任务时生成)
   */
  @ApiModelProperty("业务单号")
  @TableField(value = "business_code")
  @Column(name = "business_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 业务单号 '")
  private String businessCode;

  /**
   * 销量目标
   */
  @ApiModelProperty("销量目标")
  @TableField(value = "sale_target")
  @Column(name = "sale_target", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 销量目标 '")
  private BigDecimal saleTarget;

  /**
   * 实际销量
   */
  @ApiModelProperty("实际销量")
  @TableField(value = "actual_sales")
  @Column(name = "actual_sales", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 实际销量 '")
  private BigDecimal actualSales;

  /**
   * 分利状态(Y/N)
   */
  @ApiModelProperty("分利状态(Y/N)")
  @TableField(value = "profit_status")
  @Column(name = "profit_status", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 分利状态(Y/N) '")
  private String profitStatus;
}
