package com.biz.crm.cps.business.policy.quantify.fiscal.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * @author jerry7
 * @date 2021/8/7 16:08
 * 包量任务分利表达式实体
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "QuantifyTaskExpression", description = "包量任务分利表达式实体")
@TableName("fiscal_quantify_task_expression")
public class QuantifyTaskExpression extends BaseIdEntity {

  private static final long serialVersionUID = 1753856760216612271L;
  /**
   * 业务单号(生成包量任务时生成)
   */
  @ApiModelProperty("业务单号")
  @TableField(value = "business_code")
  @Column(name = "business_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 业务单号 '")
  private String businessCode;

  /**
   * 奖励条件标志(固定额度，定额随机)
   */
  @ApiModelProperty("奖励条件标志(固定额度，定额随机)")
  @TableField(value = "award_condition_flag")
  @Column(name = "award_condition_flag", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 奖励条件标志(固定额度，定额随机) '")
  private String awardConditionFlag;

  /**
   * 奖励条件名称(固定额度，定额随机)
   */
  @ApiModelProperty("奖励条件名称(固定额度，定额随机)")
  @TableField(value = "award_condition_name")
  @Column(name = "award_condition_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 奖励条件名称(固定额度，定额随机) '")
  private String awardConditionName;

  /**
   * 奖励方式标志
   */
  @ApiModelProperty("奖励方式标志")
  @TableField(value = "reward_method_flag")
  @Column(name = "reward_method_flag", nullable = false, length = 16, columnDefinition = "VARCHAR(16) COMMENT ' 奖励方式标志 '")
  private String rewardMethodFlag;

  /**
   * 奖励方式名称
   */
  @Column(name = "reward_method_name", nullable = false, length = 16, columnDefinition = "VARCHAR(16) COMMENT ' 奖励方式名称 '")
  @ApiModelProperty("奖励方式名称")
  @TableField(value = "reward_method_name")
  private String rewardMethodName;

  /**
   * 阶梯达成比例
   */
  @ApiModelProperty("阶梯达成比例")
  @TableField(value = "reach_rate")
  @Column(name = "reach_rate", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 达成比例 '")
  private BigDecimal reachRate;

  /**
   * 奖励数据
   */
  @ApiModelProperty("奖励数据")
  @TableField(value = "reward_data")
  @Column(name = "reward_data", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 奖励额度 '")
  private BigDecimal rewardData;

  @ApiModelProperty("赠品编码")
  @Column(name = "gift_code", nullable = false, length = 16, columnDefinition = "VARCHAR(128) COMMENT ' 赠品编码 '")
  @TableField(value = "gift_code")
  private String giftCode;
}
