package com.biz.crm.cps.business.policy.quantify.fiscal.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.bisiness.policy.quantify.sdk.dto.QuantifyTaskDto;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyTask;
import java.util.Date;
import java.util.List;
import org.apache.ibatis.annotations.Param;

/**
 * @author jerry7
 * @date 2021/8/9 19:07 包量任务mapper
 */
public interface QuantifyTaskMapper extends BaseMapper<QuantifyTask> {

  /**
   * 条件分页查询包量任务列表
   *
   * @param page 分页信息
   * @param quantifyTaskDto 筛选条件
   * @return 包量任务列表
   */
  List<QuantifyTask> findByConditions(
      Page<QuantifyTask> page, @Param("dto") QuantifyTaskDto quantifyTaskDto);

  /**
   * 根据业务编码查询包量任务
   *
   * @param businessCode 业务编码
   * @return 包量任务实体
   */
  QuantifyTask findByBusinessCode(@Param("businessCode") String businessCode);

  /**
   * 根据协议id查询对应状态的包量任务(任务开始时间升序)
   *
   * @param agreementId 协议id
   * @param taskStatus 任务状态
   * @param startTime 筛选任务开始时间，返回任务开始时间小于此时间的列表
   * @return 包量任务列表
   */
  List<QuantifyTask> findByAgreementIdAndStatus(
      @Param("agreementId") String agreementId,
      @Param("taskStatus") String taskStatus,
      @Param("startTime") Date startTime);

  /**
   * 所有有效的包量任务
   *
   * @return
   */
  List<QuantifyTask> findByTaskStatus();

  /**
   * 根据终端编码和商品编码获取当前正在进行的单品纬度的包量任务明细
   *
   * @param terminalCode
   * @param productCode
   * @return
   */
  List<QuantifyTask> findMaterialCurTaskByTerminalCodeAndProductCode(
      @Param("terminalCode") String terminalCode, @Param("productCode") String productCode);
}
