package com.biz.crm.cps.business.policy.quantify.fiscal.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyFiscal;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.mapper.QuantifyFiscalMapper;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 包量政策财年数据处理repository
 * @Author: zengxingwang
 * @Date: 2021/11/10 16:11
 */
@Component
public class QuantifyFiscalRepository extends ServiceImpl<QuantifyFiscalMapper, QuantifyFiscal> {

  /**
   * 根据包量政策id查询
   * @param quantifyPolicyId
   * @return
   */
  public List<QuantifyFiscal> findByQuantifyPolicyId(String quantifyPolicyId) {
    return this.lambdaQuery().eq(QuantifyFiscal::getQuantifyPolicyId, quantifyPolicyId).list();
  }
}
