package com.biz.crm.cps.business.policy.quantify.fiscal.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.bisiness.policy.quantify.sdk.dto.QuantifyPolicyDto;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.mapper.QuantifyPolicyMapper;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyPolicy;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author jerry7
 * @date 2021/8/12 15:18
 * 包量政策数据处理repository
 */
@Component
public class QuantifyPolicyRepository extends ServiceImpl<QuantifyPolicyMapper, QuantifyPolicy> {

  @Resource
  private QuantifyPolicyMapper policyMapper;

  /**
   * 根据主键id查询包量政策详情
   * @param id 主键ID
   * @return 包量政策详情
   */
  public QuantifyPolicy findDetailById(@Param("id") String id) {
    return this.policyMapper.findDetailsById(id);
  }

  /**
   * 通过模板编码查询包量政策详情
   * @param templateCode 模板编码
   * @return 包量政策
   */
  public QuantifyPolicy findDetailByTemplateCode(@Param("templateCode") String templateCode) {
    return this.policyMapper.findDetailsByTemplateCode(templateCode);
  }

  /**
   * 根据模板编码批量获取包量政策
   * @param dto 模板编码集合
   * @return 包量政策主体
   */
  public List<QuantifyPolicy> findByConditions(QuantifyPolicyDto dto){
    return this.policyMapper.findByConditions(dto);
  };

  /**
   * 根据模板编码删除关联包量政策
   * @param templateCode
   */
  public void deleteByTemplateCode(String templateCode) {
    this.lambdaUpdate().eq(QuantifyPolicy::getTemplateCode, templateCode).remove();
  }
}
