package com.biz.crm.cps.business.policy.quantify.fiscal.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyStatistics;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.mapper.QuantifyStatisticsMapper;
import org.springframework.stereotype.Component;

/**
 * 包量统计信息持久化
 * @Author: zengxingwang
 * @Date: 2021/11/24 14:33
 */
@Component
public class QuantifyStatisticsRepository extends ServiceImpl<QuantifyStatisticsMapper, QuantifyStatistics> {

  /**
   * 根据业务编码查询
   * @param businessCode
   * @return
   */
  public QuantifyStatistics findByBusinessCode(String businessCode) {
    QueryWrapper<QuantifyStatistics> queryWrapper = new QueryWrapper<>();
    queryWrapper.eq("business_code", businessCode);
    return this.getOne(queryWrapper);
  }
}
