package com.biz.crm.cps.business.policy.quantify.fiscal.local.service;

import com.biz.crm.cps.bisiness.policy.quantify.sdk.dto.QuantifyPolicyDto;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementPolicyDto;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementTemplateVo;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyPolicy;

import java.util.List;

/**
 * @author jerry7
 * @date 2021/8/9 18:51
 * 包量政策接口
 */
public interface QuantifyPolicyService {

  /**
   * 创建包量政策
   *
   * @param agreementPolicyDto 包量政策实体
   * @return 创建结果
   */
  QuantifyPolicy create(AgreementPolicyDto agreementPolicyDto);

  /**
   * 根据id获取包量政策详情
   * @param id 包量政策主键
   * @return 包量政策主体
   */
  QuantifyPolicy findById(String id);

  /**
   * 根据id获取包量政策详情
   * @param templateCode 包量政策主键
   * @return 包量政策主体
   */
  QuantifyPolicy findByTemplateCode(String templateCode);

  /**
   * 根据模板编码批量获取包量政策
   * @param quantifyPolicyDto 查询dto
   * @return 包量政策主体
   */
  List<QuantifyPolicy> findByConditions(QuantifyPolicyDto quantifyPolicyDto);

  /**
   * 创建包量政策
   *
   * @param quantifyPolicy 包量政策实体
   * @return 创建结果
   */
  QuantifyPolicy createFrom(QuantifyPolicy quantifyPolicy);

  /**
   * 根据模板id查询包量政策详情
   * @param templateCode 协议模板id
   * @return 包量政策详情
   */
  QuantifyPolicy findDetailByTemplateCode(String templateCode);

  /**
   * 创建包量政策是验证物料重复
   * @param agreementTemplateVo 模板vo
   * @param agreementPolicyDto 政策vo
   */
  void validatePolicyScope(AgreementTemplateVo agreementTemplateVo, AgreementPolicyDto agreementPolicyDto);

  /**
   * 修改包量信息
   * @param deserialize
   * @param before
   */
  void update(AgreementPolicyDto deserialize, Boolean before);
}
