package com.biz.crm.cps.business.policy.quantify.fiscal.local.service.builder;

import com.biz.crm.cps.business.agreement.sdk.vo.AgreementLadderVo;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyTask;

import java.util.List;

/**
 * @author jerry7
 * @date 2021/8/25 15:02
 * 包量任务装配策略
 */
public interface QuantifyTaskBuilder {

  /**
   * 包量任务构造器对应结算周期，当需要新增构造器时请确保此周期类型与包量政策传递的结算周期一致
   * @return 结算周期
   */
  String quantifyTaskCycle();

  /**
   * 组装包量任务(自然年)
   * @param agreementVo 包量协议
   * @param agreementLadderVo 协议阶梯
   * @return 包量任务
   */
  List<QuantifyTask> assemblyQuantifyTask(AgreementVo agreementVo, AgreementLadderVo agreementLadderVo);

  /**
   * 组装包量任务(财年)
   * @param agreementVo 包量协议
   * @param agreementLadderVo 协议阶梯
   * @return 包量任务
   */
  List<QuantifyTask> assemblyQuantifyTaskFiscal(AgreementVo agreementVo, AgreementLadderVo agreementLadderVo, String quantifyPolicyId);
}
