package com.biz.crm.cps.business.policy.quantify.fiscal.local.service.builder;

import com.biz.crm.cps.bisiness.policy.quantify.sdk.constant.QuantifyConstant;
import com.biz.crm.cps.bisiness.policy.quantify.sdk.constant.QuantifyTaskStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementLadderVo;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyFiscal;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyTask;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.repository.QuantifyFiscalRepository;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.utils.QuantifyUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author jerry7
 * @date 2021/8/25 15:09
 * 按月实现包量任务的组装
 */
@Component
public class QuantifyTaskMonthBuilder implements QuantifyTaskBuilder {

  @Autowired
  private QuantifyFiscalRepository quantifyFiscalRepository;

  @Override
  public String quantifyTaskCycle() {
    return QuantifyConstant.MONTH;
  }

  @Override
  public List<QuantifyTask> assemblyQuantifyTask(AgreementVo agreementVo, AgreementLadderVo agreementLadderVo) {
    List<QuantifyTask> taskList = Lists.newArrayList();
    if(!ObjectUtils.allNotNull(agreementVo,agreementLadderVo)){
      return taskList;
    }
    Date effectiveTime = agreementVo.getEffectiveStartTime();
    Date now = new Date();
    QuantifyTaskStatusEnum statusEnum = QuantifyTaskStatusEnum.STATUS_WAIT;
    if (effectiveTime.before(now)) {
      effectiveTime = now;
      //当协议生效时间小于当前时间，即签署协议时协议已生效，则当前第一个任务为进行中，其余任务为待执行
      statusEnum = QuantifyTaskStatusEnum.STATUS_DOING;
    }
    while (effectiveTime.before(agreementVo.getEffectiveEndTime())) {
      Calendar calendar = Calendar.getInstance();
      calendar.setTime(effectiveTime);
      //获取当前月份
      int nowMonth = calendar.get(Calendar.MONTH) + 1;
      //获取当前年份
      int nowYear = calendar.get(Calendar.YEAR);
      //构造包量任务
      QuantifyTask quantifyTask = new QuantifyTask();
      quantifyTask.setTaskStartTime(effectiveTime);
      quantifyTask.setTaskEndTime(DateUtils.addSeconds(DateUtils.ceiling(effectiveTime, Calendar.MONTH), -1));
      quantifyTask.setTaskName(nowYear + "年第" + nowMonth + "月包量任务");
      quantifyTask.setTaskStatus(statusEnum.getCode());
      quantifyTask.setSaleTarget(QuantifyUtils.getScaleByMonth(nowMonth, agreementLadderVo));
      taskList.add(quantifyTask);
      //同一个终端同一商品维度在同一时间段内只能存在一个包量任务，故生成包量任务后将后续任务状态置为待执行
      statusEnum = QuantifyTaskStatusEnum.STATUS_WAIT;
      //结算方式为月份，则以一个自然月为分割单位处理时间
      effectiveTime = DateUtils.ceiling(effectiveTime, Calendar.MONTH);
    }
    return taskList;
  }

  @Override
  public List<QuantifyTask> assemblyQuantifyTaskFiscal(AgreementVo agreementVo, AgreementLadderVo agreementLadderVo, String quantifyPolicyId) {
    List<QuantifyTask> taskList = Lists.newArrayList();
    if(!ObjectUtils.allNotNull(agreementVo,agreementLadderVo)){
      return taskList;
    }
    List<QuantifyFiscal> quantifyFiscals = quantifyFiscalRepository.findByQuantifyPolicyId(quantifyPolicyId);
    Map<Integer, String> fiscalMap = new HashMap<>();
    for(QuantifyFiscal quantifyFiscal : quantifyFiscals){
      fiscalMap.put(quantifyFiscal.getFiscalMonth(), quantifyFiscal.getNatureYearMonth());
    }
    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
    Date fiscal = new Date();
    try {
      String yearMonth = fiscalMap.get(1);
      fiscal = format.parse(yearMonth);
    } catch (ParseException e) {
      e.printStackTrace();
    }
    Date effectiveTime = agreementVo.getEffectiveStartTime();
    QuantifyTaskStatusEnum statusEnum = QuantifyTaskStatusEnum.STATUS_WAIT;
    if (effectiveTime.before(fiscal)) {
      effectiveTime = fiscal;
      //当协议生效时间小于当前时间，即签署协议时协议已生效，则当前第一个任务为进行中，其余任务为待执行
      statusEnum = QuantifyTaskStatusEnum.STATUS_DOING;
    }
    while (effectiveTime.before(agreementVo.getEffectiveEndTime())) {
      Calendar calendar = Calendar.getInstance();
      calendar.setTime(effectiveTime);
      //获取当前月份
      int nowMonth = calendar.get(Calendar.MONTH) + 1;
      //获取当前年份
      int nowYear = calendar.get(Calendar.YEAR);
      //构造包量任务
      QuantifyTask quantifyTask = new QuantifyTask();
      quantifyTask.setTaskStartTime(effectiveTime);
      quantifyTask.setTaskEndTime(DateUtils.addSeconds(DateUtils.ceiling(effectiveTime, Calendar.MONTH), -1));
      quantifyTask.setTaskName(nowYear + "年第" + nowMonth + "月包量任务");
      quantifyTask.setTaskStatus(statusEnum.getCode());
      quantifyTask.setSaleTarget(QuantifyUtils.getScaleByMonth(nowMonth, agreementLadderVo));
      taskList.add(quantifyTask);
      //同一个终端同一商品维度在同一时间段内只能存在一个包量任务，故生成包量任务后将后续任务状态置为待执行
      statusEnum = QuantifyTaskStatusEnum.STATUS_WAIT;
      //结算方式为月份，则以一个自然月为分割单位处理时间
      effectiveTime = DateUtils.ceiling(effectiveTime, Calendar.MONTH);
    }
    return taskList;
  }
}
