package com.biz.crm.cps.business.policy.quantify.fiscal.local.service.internal;

import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyConfiguration;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyPolicy;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyRange;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyStatistics;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyTask;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.repository.QuantifyStatisticsRepository;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.repository.QuantifyTaskRepository;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.service.QuantifyPolicyService;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.service.QuantifyStatisticsTaskService;
import com.biz.crm.cps.business.product.sdk.common.constant.MaterialDimensionConstant;
import com.biz.crm.cps.business.product.sdk.service.MaterialVoService;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordPageDto;
import com.biz.crm.cps.external.barcode.sdk.service.ScanCodeRecordVoService;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

/**
 *  包量任务统计接口实现--- 改为记录扫码实际扫码记录
 * @Author: zengxingwang
 * @Date: 2021/11/23 16:43
 */
@Service
public class QuantifyStatisticsTaskServiceImpl implements QuantifyStatisticsTaskService {

  @Autowired
  private QuantifyTaskRepository quantifyTaskRepository;
  @Autowired
  private QuantifyPolicyService quantifyPolicyService;
  @Autowired
  private MaterialVoService materialVoService;
  @Autowired
  private ScanCodeRecordVoService scanCodeRecordVoService;
  @Autowired
  private QuantifyStatisticsRepository quantifyStatisticsRepository;



  /**
   * 作废
   * 包量任务实际量统计(手动触发)
   * 时时： * * * * * ?
   * 分钟： 0 * * * * ?
   * @DynamicTaskService(cornExpression = "* * * * * ?", taskDesc = "启动/关闭任务")
   */
  @Override
  @Transactional
  @Deprecated
  public void triggerTask() {
    //1.所有有效的包量任务
    List<QuantifyTask> tasks = quantifyTaskRepository.findByTaskStatus();
    //2.
    if(!CollectionUtils.isEmpty(tasks)) {
      for (QuantifyTask task : tasks) {
        BigDecimal total = BigDecimal.ZERO;
        QuantifyPolicy policy = task.getQuantifyPolicy();
        for(QuantifyConfiguration configuration : policy.getQuantifyConfigurations()){
          BigDecimal scanCount = BigDecimal.ZERO;
          ScanCodeRecordPageDto scanCodeRecordPageDto = new ScanCodeRecordPageDto();
          scanCodeRecordPageDto.setCreateTimeStart(task.getTaskStartTime());
          if(task.getProfitTime() == null){
            scanCodeRecordPageDto.setCreateTimeEnd(task.getTaskEndTime());
          }else {
            scanCodeRecordPageDto.setCreateTimeEnd(task.getProfitTime());
          }
          if (MaterialDimensionConstant.DIMENSION_ALL.equals(policy.getDimensionFlag())) {
            //如果商品标签是全部，则直接调用扫码模块获取该时间段内扫码数量
            scanCodeRecordPageDto.setProductCodes(Lists.newArrayList());
          } else {
            //非全部商品，则通过产品维度获取物料编码集合，然后调用扫码模块获取扫码数量
            List<String> dimensionCodes = configuration.getQuantifyRanges().stream().map(QuantifyRange::getSpecialCode).collect(Collectors.toList());
            List<String> materialCodes = materialVoService.findMaterialCodeByDimensionCodesAndDimensionType(dimensionCodes, policy.getDimensionFlag());
            if (!CollectionUtils.isEmpty(materialCodes)) {
              scanCodeRecordPageDto.setProductCodes(materialCodes);
            }
          }
          scanCount = scanCodeRecordVoService.countSalesByScanCodeRecordPageDto(scanCodeRecordPageDto);
          total = total.add(scanCount);
        }
        //3.保存
        QuantifyStatistics old = quantifyStatisticsRepository.findByBusinessCode(task.getBusinessCode());
        if(old != null){
          old.setAmount(total);
          quantifyStatisticsRepository.updateById(old);
        }else {
          QuantifyStatistics quantifyStatistics = new QuantifyStatistics();
          quantifyStatistics.setBusinessCode(task.getBusinessCode());
          quantifyStatistics.setAmount(total);
          quantifyStatisticsRepository.save(quantifyStatistics);
        }
      }
    }
  }
}
