package com.biz.crm.cps.business.policy.quantify.fiscal.local.service.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.bisiness.policy.quantify.sdk.enums.QuantityTaskTypeEnums;
import com.biz.crm.cps.bisiness.policy.quantify.sdk.service.ScanCodeQuantityTaskVoService;
import com.biz.crm.cps.bisiness.policy.quantify.sdk.vo.ScanCodeQuantityTaskItemVo;
import com.biz.crm.cps.bisiness.policy.quantify.sdk.vo.ScanCodeQuantityTaskVo;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyTask;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.repository.QuantifyTaskRepository;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 扫码政策任务完成情况接口实现
 *
 * @author sunx
 * @date 2021/12/9
 */
@Service
public class ScanCodeQuantityTaskVoServiceImpl implements ScanCodeQuantityTaskVoService {

  @Autowired(required = false)
  private LoginUserService loginUserService;

  @Autowired private QuantifyTaskRepository quantifyTaskRepository;

  @Override
  public List<ScanCodeQuantityTaskVo> findScanCodeQuantityTaskVoList() {
    LoginUserDetailsForCPS loginUser = this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
    Validate.notNull(loginUser, "未获取到操作用户信息");
    String terminalCode = loginUser.getConsumerCode();
    Validate.notBlank(terminalCode, "用户对应的终端编码不能为空");

    List<QuantifyTask> tasks = this.quantifyTaskRepository.findCurTaskByTerminalCode(terminalCode);
    if (CollectionUtils.isEmpty(tasks)) {
      return null;
    }
    Map<String, List<QuantifyTask>> map =
        tasks.stream()
            .filter(a -> StringUtils.isNotBlank(a.getAgreementId()))
            .collect(Collectors.groupingBy(QuantifyTask::getAgreementId));
    List<ScanCodeQuantityTaskVo> list = Lists.newArrayList();
    for (Entry<String, List<QuantifyTask>> item : map.entrySet()) {
      ScanCodeQuantityTaskVo cur = new ScanCodeQuantityTaskVo();
      cur.setTaskName(item.getValue().get(0).getAgreementName());
      List<String> curList = Lists.newArrayList();
      Map<String, ScanCodeQuantityTaskItemVo> mapItem = Maps.newHashMap();
      Map<String,QuantifyTask> curMap =
          item.getValue().stream()
              .filter(a->StringUtils.isNotBlank(a.getTaskType()))
              .collect(Collectors.toMap(QuantifyTask::getTaskType, Function.identity(),(a,b)->b));
      for (QuantityTaskTypeEnums typeEnums : QuantityTaskTypeEnums.values()) {
        QuantifyTask task = curMap.get(typeEnums.getCode());
        if( Objects.isNull(task)){
          continue;
        }
        curList.add(typeEnums.getDesc());
        ScanCodeQuantityTaskItemVo curVo = new ScanCodeQuantityTaskItemVo();
        curVo.setSaleTarget(
            Optional.ofNullable(task.getSaleTarget()).orElse(BigDecimal.ZERO));
        curVo.setSaleActual(
            Optional.ofNullable(task.getSaleActual()).orElse(BigDecimal.ZERO));
        if (BigDecimal.ZERO.compareTo(curVo.getSaleTarget()) < 0) {
          curVo.setReachRate(
              curVo
                  .getSaleActual()
                  .divide(curVo.getSaleTarget(), 4, RoundingMode.HALF_UP)
                  .multiply(new BigDecimal(100)));
        }
        mapItem.put(typeEnums.getDesc(), curVo);
      }
      cur.setMap(mapItem);
      cur.setTimeKeyList(curList);
      list.add(cur);
    }
    return list;
  }
}
