package com.biz.crm.cps.business.policy.quantify.fiscal.local.service.notifier;

import cn.hutool.json.JSONUtil;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.service.QuantifyTaskService;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordEventDto;
import com.biz.crm.cps.external.barcode.sdk.event.ScanCodeRecordEventListener;
import java.util.Objects;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * 财年包量政策扫码事件实现处理
 *
 * @author sunx
 * @date 2021/12/8
 */
@Component
@Slf4j
public class QuantifyFiscalEventListenerImpl implements ScanCodeRecordEventListener {

  /** 终端判断 */
  private static final String TERMINAL = "terminal";

  @Autowired private QuantifyTaskService quantifyTaskService;

  @Override
  @Transactional
  public void onSuccessScan(ScanCodeRecordEventDto dto) {
    log.info("财年包量政策扫码事件实现处理[{}]", JSONUtil.toJsonStr(dto));
    if (Objects.isNull(dto)
        || !TERMINAL.equals(dto.getParticipatorType())
        || StringUtils.isBlank(dto.getBarCode())
        || StringUtils.isBlank(dto.getProductCode())) {
      return;
    }
    this.quantifyTaskService.updateSaleQuantity(dto.getProductCode(),dto.getBarCode());
  }

  @Override
  public void onFailScan(ScanCodeRecordEventDto dto) {}

}
