package com.biz.crm.cps.business.policy.quantify.fiscal.local.service.observer;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.bisiness.policy.quantify.sdk.vo.QuantifyPolicyVo;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementPolicyDto;
import com.biz.crm.cps.business.agreement.sdk.dto.PolicyObserverDto;
import com.biz.crm.cps.business.agreement.sdk.service.observer.AgreementPolicyServiceObserver;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementPolicyVo;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementTemplateVo;
import com.biz.crm.cps.business.agreement.sdk.vo.PolicyRewardDataVo;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyPolicy;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.service.QuantifyPolicyService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 扫码政策，提供协议模板要求政策提供的API
 *
 * @author hefan
 */
@Component("QuantifyPolicyServiceObserverImpl")
public class QuantifyPolicyServiceObserverImpl implements AgreementPolicyServiceObserver {

  @Autowired
  private QuantifyPolicyService quantifyPolicyService;

  @Autowired
  private QuantifyPolicyPojoObserverRegister quantifyPolicyPojoObserverRegister;

  @Autowired
  private QuantifyPolicyMountRegisterImpl quantifyPolicyMountObserver;

  @Autowired
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;

  /**
   * 保存扫码政策信息到数据库
   *
   * @param agreementPolicyDto
   */
  @Override
  public void onCreate(AgreementPolicyDto agreementPolicyDto) {
    this.quantifyPolicyService.create(agreementPolicyDto);
  }

  @Override
  public AgreementPolicyVo onFindDetailsByTemplateCode(String templateCode) {
    QuantifyPolicy quantifyPolicy = this.quantifyPolicyService.findDetailByTemplateCode(templateCode);
    if (ObjectUtils.isEmpty(quantifyPolicy)) {
      return null;
    }
    QuantifyPolicyVo quantifyPolicyVo = nebulaToolkitService.copyObjectByWhiteList(quantifyPolicy, QuantifyPolicyVo.class, HashSet.class, ArrayList.class, "quantifyConfigurations", "quantifyConfigurations.quantifyRanges", "quantifyConfigurations.quantifyExpressions");
    quantifyPolicyVo.setPolicyKey(this.quantifyPolicyMountObserver.getKey());
    quantifyPolicyVo.setTemplateCode(templateCode);
    return quantifyPolicyVo;
  }

  @Override
  public void onProcessScanCode(PolicyObserverDto policyObserverDto) {
    AgreementPolicyServiceObserver.super.onProcessScanCode(policyObserverDto);
  }

  @Override
  public void onCreate(JSONObject jsonObject) {
    if (ObjectUtils.isEmpty(jsonObject)) {
      return;
    }
    JSONObject policy = jsonObject.getJSONObject(this.quantifyPolicyMountObserver.getKey());
    AgreementPolicyDto deserialize = this.quantifyPolicyPojoObserverRegister.deserialize(policy);
    if (ObjectUtils.isEmpty(deserialize)) {
      return;
    }
    deserialize.setTemplateCode(jsonObject.getString("templateCode"));
    //政策验重
    AgreementTemplateVo agreementTemplateVo = JsonUtils.json2Obj(jsonObject.getString("profitAgreementTemplate"), AgreementTemplateVo.class);
    this.quantifyPolicyService.validatePolicyScope(agreementTemplateVo, deserialize);
    this.onCreate(deserialize);
  }

  @Override
  public List<PolicyRewardDataVo> onFindPolicyRewardData(Set<String> templateCodeSet, String usertype) {
    return null;
  }

  @Override
  public void onChange(JSONObject jsonObject) {
    if (ObjectUtils.isEmpty(jsonObject)) {
      return;
    }
    JSONObject policy = jsonObject.getJSONObject(this.quantifyPolicyMountObserver.getKey());
    AgreementPolicyDto deserialize = this.quantifyPolicyPojoObserverRegister.deserialize(policy);
    if (ObjectUtils.isEmpty(deserialize)) {
      return;
    }
    deserialize.setTemplateCode(jsonObject.getString("templateCode"));
    //政策验重
    AgreementTemplateVo agreementTemplateVo = JsonUtils.json2Obj(jsonObject.getString("profitAgreementTemplate"), AgreementTemplateVo.class);
    this.quantifyPolicyService.validatePolicyScope(agreementTemplateVo, deserialize);
    //获取当前时间是否在模板签署开始时间之前，true则可进行全部覆盖，
    Boolean before = jsonObject.getBoolean("before");
    this.quantifyPolicyService.update(deserialize, before);
  }
}
