package com.biz.crm.cps.business.policy.quantify.fiscal.local.utils;

import com.biz.crm.cps.business.agreement.sdk.vo.AgreementLadderVo;
import org.apache.commons.lang3.time.DateUtils;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

/**
 * @author jerry7
 * @date 2021/8/20 10:01
 * 包量任务工具类
 */
public class QuantifyUtils {

  /**
   * 根据当前月份返回设定的对应月份设定的销量目标
   *
   * @param month             当前月份
   * @param agreementLadderVo 包量政策
   * @return 销量目标
   */
  public static BigDecimal getScaleByMonth(int month, AgreementLadderVo agreementLadderVo) {
    switch (month) {
      case 1:
        return agreementLadderVo.getJanuarySaleNum();
      case 2:
        return agreementLadderVo.getFebruarySaleNum();
      case 3:
        return agreementLadderVo.getMarchSaleNum();
      case 4:
        return agreementLadderVo.getAprilSaleNum();
      case 5:
        return agreementLadderVo.getMaySaleNum();
      case 6:
        return agreementLadderVo.getJuneSaleNum();
      case 7:
        return agreementLadderVo.getJulySaleNum();
      case 8:
        return agreementLadderVo.getAugustSaleNum();
      case 9:
        return agreementLadderVo.getSeptemberSaleNum();
      case 10:
        return agreementLadderVo.getOctoberSaleNum();
      case 11:
        return agreementLadderVo.getNovemberSaleNum();
      case 12:
      default:
        //默认返回12月份销量
        return agreementLadderVo.getDecemberSaleNum();
    }
  }

  /**
   * 根据时间范围获取销量目标，获取时间段内每个月的销量目标进行累加
   *
   * @param startTime         开始时间
   * @param endTime           结束时间
   * @param agreementLadderVo 协议阶梯VO
   * @return 销量目标
   */
  public static BigDecimal getScaleByTimeInterval(Date startTime, Date endTime, AgreementLadderVo agreementLadderVo) {
    BigDecimal target = BigDecimal.ZERO;
    while (startTime.before(endTime)) {
      target = target.add(getScaleByMonth(startTime.getMonth() + 1, agreementLadderVo));
      startTime = DateUtils.ceiling(startTime, Calendar.MONTH);
    }
    return target;
  }
}
