/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.quantify.fiscal.local.controller;

import com.biz.crm.cps.bisiness.policy.quantify.sdk.dto.QuantifyTaskDto;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyTask;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.service.QuantifyTaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/quantify/task"})
@Api(tags={"\u5305\u91cf\u4efb\u52a1\u76f8\u5173\u63a5\u53e3"})
public class QuantifyTaskController {
    private static final Logger log = LoggerFactory.getLogger(QuantifyTaskController.class);
    @Autowired
    private QuantifyTaskService quantifyTaskService;

    @ApiOperation(value="\u521b\u5efa\u5305\u91cf\u4efb\u52a1")
    @PostMapping(value={""})
    public Result<List<QuantifyTask>> create(@RequestBody String agreementId) {
        try {
            List<QuantifyTask> taskList = this.quantifyTaskService.create(agreementId);
            return Result.ok(taskList);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u83b7\u53d6\u5305\u91cf\u4efb\u52a1")
    @PostMapping(value={"findByConditions"})
    public Result<List<QuantifyTask>> findByConditions(@PageableDefault(value=50) Pageable pageable, @RequestBody QuantifyTaskDto quantifyTaskDto) {
        try {
            List<QuantifyTask> taskList = this.quantifyTaskService.findByConditions(pageable, quantifyTaskDto);
            return Result.ok(taskList);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u624b\u52a8\u7ed3\u7b97\u5305\u91cf\u4efb\u52a1")
    @GetMapping(value={"summaryQuantityTask"})
    public Result<?> summaryQuantityTask(@RequestParam(value="businessCode") String businessCode) {
        try {
            this.quantifyTaskService.triggerQuantityTask(businessCode);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

