/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.quantify.fiscal.local.service.builder;

import com.biz.crm.cps.bisiness.policy.quantify.sdk.constant.QuantifyTaskStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementLadderVo;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyFiscal;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyTask;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.repository.QuantifyFiscalRepository;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.service.builder.QuantifyTaskBuilder;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.utils.QuantifyUtils;
import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QuantifyTaskHalfYearBuilder
implements QuantifyTaskBuilder {
    @Autowired
    private QuantifyFiscalRepository quantifyFiscalRepository;

    @Override
    public String quantifyTaskCycle() {
        return "halfYear";
    }

    @Override
    public List<QuantifyTask> assemblyQuantifyTask(AgreementVo agreementVo, AgreementLadderVo agreementLadderVo) {
        ArrayList taskList = Lists.newArrayList();
        if (!ObjectUtils.allNotNull((Object[])new Object[]{agreementVo, agreementLadderVo})) {
            return taskList;
        }
        Date effectiveTime = agreementVo.getEffectiveStartTime();
        Date now = new Date();
        QuantifyTaskStatusEnum statusEnum = QuantifyTaskStatusEnum.STATUS_WAIT;
        if (effectiveTime.before(now)) {
            effectiveTime = now;
            statusEnum = QuantifyTaskStatusEnum.STATUS_DOING;
        }
        while (effectiveTime.before(agreementVo.getEffectiveEndTime())) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(effectiveTime);
            int nowMonth = calendar.get(2) + 1;
            int nowYear = calendar.get(1);
            int addMonths = nowMonth % 6;
            QuantifyTask quantifyTask = new QuantifyTask();
            quantifyTask.setTaskStartTime(effectiveTime);
            effectiveTime = addMonths == 0 ? DateUtils.ceiling((Date)effectiveTime, (int)2) : DateUtils.addMonths((Date)DateUtils.ceiling((Date)effectiveTime, (int)2), (int)(6 - addMonths));
            quantifyTask.setTaskEndTime(DateUtils.addSeconds((Date)effectiveTime, (int)-1));
            int halfYear = nowMonth / 6;
            Date targetStartTime = quantifyTask.getTaskStartTime();
            if (halfYear > 0) {
                targetStartTime = DateUtils.setMonths((Date)targetStartTime, (int)6);
                quantifyTask.setTaskName(nowYear + "\u5e74\u4e0b\u534a\u5e74\u5305\u91cf\u4efb\u52a1");
            } else {
                targetStartTime = DateUtils.setMonths((Date)targetStartTime, (int)0);
                quantifyTask.setTaskName(nowYear + "\u5e74\u4e0a\u534a\u5e74\u5305\u91cf\u4efb\u52a1");
            }
            quantifyTask.setTaskStatus(statusEnum.getCode());
            quantifyTask.setSaleTarget(QuantifyUtils.getScaleByTimeInterval(targetStartTime, quantifyTask.getTaskEndTime(), agreementLadderVo));
            taskList.add(quantifyTask);
            statusEnum = QuantifyTaskStatusEnum.STATUS_WAIT;
        }
        return taskList;
    }

    @Override
    public List<QuantifyTask> assemblyQuantifyTaskFiscal(AgreementVo agreementVo, AgreementLadderVo agreementLadderVo, String quantifyPolicyId) {
        ArrayList taskList = Lists.newArrayList();
        if (!ObjectUtils.allNotNull((Object[])new Object[]{agreementVo, agreementLadderVo})) {
            return taskList;
        }
        List<QuantifyFiscal> quantifyFiscals = this.quantifyFiscalRepository.findByQuantifyPolicyId(quantifyPolicyId);
        HashMap<Integer, String> fiscalMap = new HashMap<Integer, String>();
        for (QuantifyFiscal quantifyFiscal : quantifyFiscals) {
            fiscalMap.put(quantifyFiscal.getFiscalMonth(), quantifyFiscal.getNatureYearMonth());
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Date fiscal = new Date();
        try {
            String yearMonth = (String)fiscalMap.get(1);
            fiscal = format.parse(yearMonth);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Date effectiveTime = agreementVo.getEffectiveStartTime();
        QuantifyTaskStatusEnum statusEnum = QuantifyTaskStatusEnum.STATUS_WAIT;
        if (effectiveTime.before(fiscal)) {
            effectiveTime = fiscal;
            statusEnum = QuantifyTaskStatusEnum.STATUS_DOING;
        }
        while (effectiveTime.before(agreementVo.getEffectiveEndTime())) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(effectiveTime);
            int nowMonth = calendar.get(2) + 1;
            int nowYear = calendar.get(1);
            Calendar end = Calendar.getInstance();
            end.setTime(fiscal);
            int s = end.get(2);
            int addMonths = 0;
            if (nowMonth != s) {
                addMonths = (nowMonth - s) % 6;
            }
            QuantifyTask quantifyTask = new QuantifyTask();
            quantifyTask.setTaskStartTime(effectiveTime);
            effectiveTime = addMonths == 0 ? DateUtils.ceiling((Date)effectiveTime, (int)2) : DateUtils.addMonths((Date)DateUtils.ceiling((Date)effectiveTime, (int)2), (int)(6 - addMonths));
            quantifyTask.setTaskEndTime(DateUtils.addSeconds((Date)effectiveTime, (int)-1));
            int halfYear = (nowMonth - s) / 6;
            Date targetStartTime = quantifyTask.getTaskStartTime();
            if (halfYear > 0) {
                targetStartTime = DateUtils.setMonths((Date)targetStartTime, (int)6);
                quantifyTask.setTaskName(nowYear + "\u5e74\u4e0b\u534a\u5e74\u5305\u91cf\u4efb\u52a1");
            } else {
                targetStartTime = DateUtils.setMonths((Date)targetStartTime, (int)0);
                quantifyTask.setTaskName(nowYear + "\u5e74\u4e0a\u534a\u5e74\u5305\u91cf\u4efb\u52a1");
            }
            quantifyTask.setTaskStatus(statusEnum.getCode());
            quantifyTask.setSaleTarget(QuantifyUtils.getScaleByTimeInterval(targetStartTime, quantifyTask.getTaskEndTime(), agreementLadderVo));
            taskList.add(quantifyTask);
            statusEnum = QuantifyTaskStatusEnum.STATUS_WAIT;
        }
        return taskList;
    }
}

