/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.quantify.fiscal.local.service.internal;

import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyConfiguration;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyPolicy;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyRange;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyStatistics;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyTask;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.repository.QuantifyStatisticsRepository;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.repository.QuantifyTaskRepository;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.service.QuantifyPolicyService;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.service.QuantifyStatisticsTaskService;
import com.biz.crm.cps.business.product.sdk.service.MaterialVoService;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordPageDto;
import com.biz.crm.cps.external.barcode.sdk.service.ScanCodeRecordVoService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class QuantifyStatisticsTaskServiceImpl
implements QuantifyStatisticsTaskService {
    @Autowired
    private QuantifyTaskRepository quantifyTaskRepository;
    @Autowired
    private QuantifyPolicyService quantifyPolicyService;
    @Autowired
    private MaterialVoService materialVoService;
    @Autowired
    private ScanCodeRecordVoService scanCodeRecordVoService;
    @Autowired
    private QuantifyStatisticsRepository quantifyStatisticsRepository;

    @Override
    @Transactional
    @Deprecated
    public void triggerTask() {
        List<QuantifyTask> tasks = this.quantifyTaskRepository.findByTaskStatus();
        if (!CollectionUtils.isEmpty(tasks)) {
            for (QuantifyTask task : tasks) {
                BigDecimal total = BigDecimal.ZERO;
                QuantifyPolicy policy = task.getQuantifyPolicy();
                for (QuantifyConfiguration configuration : policy.getQuantifyConfigurations()) {
                    BigDecimal scanCount = BigDecimal.ZERO;
                    ScanCodeRecordPageDto scanCodeRecordPageDto = new ScanCodeRecordPageDto();
                    scanCodeRecordPageDto.setCreateTimeStart(task.getTaskStartTime());
                    if (task.getProfitTime() == null) {
                        scanCodeRecordPageDto.setCreateTimeEnd(task.getTaskEndTime());
                    } else {
                        scanCodeRecordPageDto.setCreateTimeEnd(task.getProfitTime());
                    }
                    if ("DIMENSION_ALL".equals(policy.getDimensionFlag())) {
                        scanCodeRecordPageDto.setProductCodes((List)Lists.newArrayList());
                    } else {
                        List dimensionCodes = configuration.getQuantifyRanges().stream().map(QuantifyRange::getSpecialCode).collect(Collectors.toList());
                        List materialCodes = this.materialVoService.findMaterialCodeByDimensionCodesAndDimensionType(dimensionCodes, policy.getDimensionFlag());
                        if (!CollectionUtils.isEmpty((Collection)materialCodes)) {
                            scanCodeRecordPageDto.setProductCodes(materialCodes);
                        }
                    }
                    scanCount = this.scanCodeRecordVoService.countSalesByScanCodeRecordPageDto(scanCodeRecordPageDto);
                    total = total.add(scanCount);
                }
                QuantifyStatistics old = this.quantifyStatisticsRepository.findByBusinessCode(task.getBusinessCode());
                if (old != null) {
                    old.setAmount(total);
                    this.quantifyStatisticsRepository.updateById((Object)old);
                    continue;
                }
                QuantifyStatistics quantifyStatistics = new QuantifyStatistics();
                quantifyStatistics.setBusinessCode(task.getBusinessCode());
                quantifyStatistics.setAmount(total);
                this.quantifyStatisticsRepository.save((Object)quantifyStatistics);
            }
        }
    }
}

