/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.quantify.fiscal.local.service.internal;

import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.bisiness.policy.quantify.sdk.constant.ProfitStatusEnum;
import com.biz.crm.cps.bisiness.policy.quantify.sdk.constant.QuantifyTaskStatusEnum;
import com.biz.crm.cps.bisiness.policy.quantify.sdk.dto.QuantifyTaskDto;
import com.biz.crm.cps.business.agreement.sdk.common.enums.AgreementStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.common.enums.AutoSignEnum;
import com.biz.crm.cps.business.agreement.sdk.common.enums.SignStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementDto;
import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import com.biz.crm.cps.business.agreement.sdk.dto.ProfitAgreementTemplatePaginationDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementLadderVoService;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementTemplateVoService;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementLadderVo;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementTemplateVo;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyConfiguration;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyExpression;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyPolicy;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyRange;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyStatistics;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyTask;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyTaskDetail;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyTaskExpression;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.repository.QuantifyStatisticsRepository;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.repository.QuantifyTaskDetailRepository;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.repository.QuantifyTaskExpressionRepository;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.repository.QuantifyTaskRepository;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.service.QuantifyPolicyService;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.service.QuantifyTaskService;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.service.builder.QuantifyTaskBuilder;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.service.observer.QuantifyPolicyMountRegisterImpl;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.utils.SchedulerUtils;
import com.biz.crm.cps.business.policy.sdk.dto.PolicyRewardConditionDto;
import com.biz.crm.cps.business.policy.sdk.service.observer.PolicyRewardServiceObserver;
import com.biz.crm.cps.business.product.sdk.service.MaterialVoService;
import com.biz.crm.cps.external.barcode.sdk.common.enums.BarCodeTypeEnum;
import com.biz.crm.cps.external.barcode.sdk.common.enums.ScanCodeExceptionEnum;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordPageDto;
import com.biz.crm.cps.external.barcode.sdk.service.BarCodeVoService;
import com.biz.crm.cps.external.barcode.sdk.service.ScanCodeRecordVoService;
import com.biz.crm.cps.external.barcode.sdk.vo.BarCodeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.bizunited.nebula.task.service.DynamicTaskSchedulerVoService;
import com.bizunited.nebula.task.vo.DynamicTaskSchedulerVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="quantifyTaskServiceImpl")
public class QuantifyTaskServiceImpl
implements QuantifyTaskService {
    private static final Logger log = LoggerFactory.getLogger(QuantifyTaskServiceImpl.class);
    @Autowired
    private AgreementVoService agreementVoService;
    @Autowired
    private QuantifyPolicyService quantifyPolicyService;
    @Autowired
    private QuantifyTaskRepository quantifyTaskRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    private MaterialVoService materialVoService;
    @Autowired
    private ScanCodeRecordVoService scanCodeRecordVoService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private List<PolicyRewardServiceObserver> policyRewardServiceObservers;
    @Autowired
    private DynamicTaskSchedulerVoService dynamicTaskSchedulerVoService;
    @Autowired
    private QuantifyTaskDetailRepository quantifyTaskDetailRepository;
    @Autowired
    private QuantifyPolicyMountRegisterImpl quantifyPolicyMountRegister;
    @Autowired
    private List<QuantifyTaskBuilder> quantifyTaskBuilderList;
    @Autowired
    private AgreementLadderVoService agreementLadderVoService;
    @Autowired
    private QuantifyTaskExpressionRepository quantifyTaskExpressionRepository;
    @Autowired
    private AgreementTemplateVoService agreementTemplateVoService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired
    private BarCodeVoService barCodeVoService;
    @Autowired
    private QuantifyStatisticsRepository quantifyStatisticsRepository;
    @Value(value="${cps.barcode.sale-standard-unit:}")
    private String saleStandardUnit;

    @Override
    @Transactional
    public List<QuantifyTask> create(String agreementId) {
        AgreementDto agreementDto = new AgreementDto();
        agreementDto.setAgreementCode(agreementId);
        Page agreementVo = this.agreementVoService.findByConditions((Pageable)PageRequest.of((int)0, (int)50), agreementDto);
        if (agreementVo != null && !CollectionUtils.isEmpty((Collection)agreementVo.getRecords())) {
            return this.create((AgreementVo)agreementVo.getRecords().get(0));
        }
        return Lists.newArrayList();
    }

    @Override
    @Transactional
    public List<QuantifyTask> create(AgreementVo agreementVo) {
        QuantifyPolicy quantifyPolicy = this.quantifyPolicyService.findByTemplateCode(agreementVo.getTemplateCode());
        Validate.notNull((Object)((Object)quantifyPolicy), (String)("\u534f\u8bae\u6a21\u677f\u7f16\u7801" + agreementVo.getAgreementCode() + "\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5305\u91cf\u653f\u7b56\uff01"), (Object[])new Object[0]);
        ArrayList quantifyTasks = Lists.newArrayList();
        quantifyPolicy.getQuantifyConfigurations().forEach(quantifyConfiguration -> {
            List<QuantifyTask> quantifyTaskList = this.buildQuantifyTask(agreementVo, (QuantifyConfiguration)((Object)quantifyConfiguration), quantifyPolicy);
            if (!CollectionUtils.isEmpty(quantifyTaskList)) {
                quantifyTasks.addAll(quantifyTaskList);
            }
        });
        this.quantifyTaskRepository.saveBatch(quantifyTasks);
        quantifyTasks.forEach(quantifyTask -> this.quantifyTaskExpressionRepository.saveBatch(quantifyTask.getQuantifyTaskExpressions()));
        quantifyTasks.forEach(task -> {
            DynamicTaskSchedulerVo taskSchedulerVo = new DynamicTaskSchedulerVo();
            if (quantifyPolicy.getRewardCycleType().equals("1")) {
                taskSchedulerVo = this.dynamicTaskSchedulerVoService.createIgnorePrefix(task.getBusinessCode(), "quantifyTaskServiceImpl", "triggerQuantityTask", SchedulerUtils.getSchedulerCron(task.getTaskType()), agreementVo.getEffectiveEndTime(), task.getTaskName(), new Object[]{task.getBusinessCode()});
            }
            if (quantifyPolicy.getRewardCycleType().equals("2")) {
                // empty if block
            }
            this.dynamicTaskSchedulerVoService.start(new String[]{taskSchedulerVo.getTaskCode()});
        });
        return quantifyTasks;
    }

    private List<QuantifyTask> buildQuantifyTask(AgreementVo agreementVo, QuantifyConfiguration quantifyConfiguration, QuantifyPolicy quantifyPolicy) {
        ArrayList quantifyTaskList = Lists.newArrayList();
        Map<String, List<QuantifyExpression>> quantifyExpressMap = this.convertMapByCalculateCycle(quantifyConfiguration);
        if (quantifyExpressMap.size() == 0) {
            return quantifyTaskList;
        }
        AgreementLadderVo agreementLadderVo = this.agreementLadderVoService.findByLadderCode(quantifyConfiguration.getAgreementLadderCode());
        if (Objects.isNull(agreementLadderVo)) {
            return quantifyTaskList;
        }
        quantifyExpressMap.forEach((key, value) -> {
            QuantifyTaskBuilder taskBuilder = this.findBuilderByCalculateCycle((String)key);
            if (Objects.isNull(taskBuilder)) {
                return;
            }
            List<Object> quantifyTasks = new ArrayList();
            if ("1".equals(quantifyPolicy.getRewardCycleType())) {
                quantifyTasks = taskBuilder.assemblyQuantifyTask(agreementVo, agreementLadderVo);
            }
            if ("2".equals(quantifyPolicy.getRewardCycleType())) {
                quantifyTasks = taskBuilder.assemblyQuantifyTaskFiscal(agreementVo, agreementLadderVo, quantifyPolicy.getId());
            }
            if (CollectionUtils.isEmpty(quantifyTasks)) {
                return;
            }
            List businessCodes = this.generateCodeService.generateCode("quantify-task-code", quantifyTasks.size());
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)businessCodes) && businessCodes.size() == quantifyTasks.size() ? 1 : 0) != 0, (String)"\u751f\u6210\u4e1a\u52a1\u5355\u53f7\u5f02\u5e38", (Object[])new Object[0]);
            for (int i = 0; i < quantifyTasks.size(); ++i) {
                QuantifyTask task = (QuantifyTask)((Object)((Object)quantifyTasks.get(i)));
                task.setProfitStatus("1");
                task.setQuantifyPolicyId(quantifyPolicy.getId());
                task.setRewardCycleType(quantifyPolicy.getRewardCycleType());
                task.setBusinessCode((String)businessCodes.get(i));
                task.setQuantifyPolicyId(quantifyConfiguration.getQuantifyPolicyId());
                task.setTaskType((String)key);
                task.setAgreementId(agreementVo.getAgreementCode());
                task.setAgreementName(agreementVo.getAgreementName());
                task.setTemplateId(agreementVo.getTemplateCode());
                task.setTemplateName(agreementVo.getBelongTemplate());
                task.setTerminalCode(agreementVo.getTerminalCode());
                task.setTerminalName(agreementVo.getRelationTerminal());
                task.setQuantifyPolicyConfigurationId(quantifyConfiguration.getId());
                task.setTenantCode(TenantUtils.getTenantCode());
                task.setOnlyHighestLevel(quantifyConfiguration.getOnlyHighestLevel());
                task.setQuantifyTaskExpressions((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)value, QuantifyExpression.class, QuantifyTaskExpression.class, HashSet.class, ArrayList.class, new String[0]));
                task.getQuantifyTaskExpressions().forEach(quantifyExpress -> {
                    quantifyExpress.setBusinessCode(task.getBusinessCode());
                    quantifyExpress.setId(null);
                });
                quantifyTaskList.add(task);
            }
        });
        return quantifyTaskList;
    }

    private Map<String, List<QuantifyExpression>> convertMapByCalculateCycle(QuantifyConfiguration quantifyConfiguration) {
        HashMap quantifyExpressionMap = Maps.newHashMap();
        quantifyConfiguration.getQuantifyExpressions().forEach(quantifyExpression -> {
            List expressions = (List)quantifyExpressionMap.get(quantifyExpression.getCalculateCycle());
            if (CollectionUtils.isEmpty((Collection)expressions)) {
                expressions = Lists.newArrayList();
            }
            expressions.add(quantifyExpression);
            quantifyExpressionMap.put(quantifyExpression.getCalculateCycle(), expressions);
        });
        return quantifyExpressionMap;
    }

    private QuantifyTaskBuilder findBuilderByCalculateCycle(String calculateCycle) {
        QuantifyTaskBuilder quantifyTaskBuilder = null;
        for (QuantifyTaskBuilder t : this.quantifyTaskBuilderList) {
            if (!t.quantifyTaskCycle().equals(calculateCycle)) continue;
            quantifyTaskBuilder = t;
            break;
        }
        return quantifyTaskBuilder;
    }

    @Override
    public QuantifyTask findById(String id) {
        return (QuantifyTask)((Object)this.quantifyTaskRepository.getById((Serializable)((Object)id)));
    }

    @Override
    public List<QuantifyTask> findByConditions(Pageable pageable, QuantifyTaskDto quantifyTaskDto) {
        return this.quantifyTaskRepository.findByConditions(pageable, quantifyTaskDto);
    }

    @Override
    @Transactional
    public void triggerQuantityTask(String businessCode) {
        QuantifyTask quantifyTask = this.quantifyTaskRepository.findByBusinessCode(businessCode);
        Validate.notNull((Object)((Object)quantifyTask), (String)("\u4e1a\u52a1\u5355\u53f7\uff1a" + businessCode + "\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u5305\u91cf\u4efb\u52a1\uff01"), (Object[])new Object[0]);
        Validate.isTrue((boolean)quantifyTask.getTaskStatus().equals(QuantifyTaskStatusEnum.STATUS_DOING.getCode()), (String)"\u53ea\u6709\u5904\u4e8e\u6267\u884c\u4e2d\u4efb\u52a1\u53ef\u4ee5\u8fdb\u884c\u7ed3\u7b97", (Object[])new Object[0]);
        QuantifyPolicy policy = this.quantifyPolicyService.findByTemplateCode(quantifyTask.getTemplateId());
        Validate.notNull((Object)((Object)policy), (String)("\u4e1a\u52a1\u5355\u53f7\uff1a" + businessCode + "\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u5305\u91cf\u653f\u7b56\uff01"), (Object[])new Object[0]);
        LoginUserAgreementDto loginUserAgreementDto = new LoginUserAgreementDto();
        loginUserAgreementDto.setSignStatus(SignStatusEnum.SIGNED.getCode());
        loginUserAgreementDto.setAgreementStatus(AgreementStatusEnum.EXECUTING.getCode());
        loginUserAgreementDto.setAgreementCode(quantifyTask.getAgreementId());
        List agreementVos = this.agreementVoService.findByConditions(loginUserAgreementDto);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)agreementVos) ? 1 : 0) != 0, (String)("\u4e1a\u52a1\u5355\u53f7\uff1a" + businessCode + "\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u5df2\u751f\u6548\u534f\u8bae\uff01"), (Object[])new Object[0]);
        ProfitAgreementTemplatePaginationDto dto = new ProfitAgreementTemplatePaginationDto();
        dto.setTemplateCode(policy.getTemplateCode());
        List agreementTemplateVos = this.agreementTemplateVoService.findByConditions(dto);
        Validate.isTrue((agreementTemplateVos.size() == 1 ? 1 : 0) != 0, (String)("\u4e1a\u52a1\u5355\u53f7\uff1a" + businessCode + "\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u6a21\u677f\u4fe1\u606f\uff01"), (Object[])new Object[0]);
        List<QuantifyTaskDetail> quantifyTaskDetails = this.buildTaskDetail(policy, quantifyTask, (AgreementTemplateVo)agreementTemplateVos.stream().findFirst().get());
        this.sendToCost(quantifyTask, quantifyTaskDetails);
        this.updateQuantifyTask(quantifyTask, quantifyTaskDetails);
        this.quantifyTaskDetailRepository.saveBatch(quantifyTaskDetails);
    }

    private List<QuantifyTaskDetail> buildTaskDetail(QuantifyPolicy policy, QuantifyTask quantifyTask, AgreementTemplateVo agreementTemplateVo) {
        ArrayList quantifyTaskDetails = Lists.newArrayList();
        policy.getQuantifyConfigurations().forEach(configuration -> {
            if (!quantifyTask.getQuantifyPolicyConfigurationId().equals(configuration.getId())) {
                return;
            }
            BigDecimal scanCount = BigDecimal.ZERO;
            ScanCodeRecordPageDto scanCodeRecordPageDto = new ScanCodeRecordPageDto();
            scanCodeRecordPageDto.setCreateTimeStart(quantifyTask.getTaskStartTime());
            if (quantifyTask.getTaskEndTime().before(agreementTemplateVo.getEffectiveEndTime())) {
                scanCodeRecordPageDto.setCreateTimeEnd(quantifyTask.getTaskEndTime());
            } else {
                scanCodeRecordPageDto.setCreateTimeEnd(agreementTemplateVo.getEffectiveEndTime());
            }
            scanCodeRecordPageDto.setScanParticipatorCode(quantifyTask.getTerminalCode());
            scanCodeRecordPageDto.setScanCodeException(ScanCodeExceptionEnum.NO.getCode());
            if ("DIMENSION_ALL".equals(policy.getDimensionFlag())) {
                scanCodeRecordPageDto.setProductCodes((List)Lists.newArrayList());
                scanCount = this.scanCodeRecordVoService.countSalesByScanCodeRecordPageDto(scanCodeRecordPageDto);
            } else {
                List dimensionCodes = configuration.getQuantifyRanges().stream().map(QuantifyRange::getSpecialCode).collect(Collectors.toList());
                List materialCodes = this.materialVoService.findMaterialCodeByDimensionCodesAndDimensionType(dimensionCodes, policy.getDimensionFlag());
                if (!CollectionUtils.isEmpty((Collection)materialCodes)) {
                    scanCodeRecordPageDto.setProductCodes(materialCodes);
                    scanCount = this.scanCodeRecordVoService.countSalesByScanCodeRecordPageDto(scanCodeRecordPageDto);
                }
            }
            BigDecimal reachRate = scanCount.divide(quantifyTask.getSaleTarget(), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
            if (quantifyTask.getOnlyHighestLevel().equals(AutoSignEnum.YES.getCode())) {
                quantifyTaskDetails.addAll(this.calculateWithOnlyHighestLevel(quantifyTask, scanCount, reachRate));
            } else {
                quantifyTaskDetails.addAll(this.calculateWithAllLevel(quantifyTask, scanCount, reachRate));
            }
        });
        return quantifyTaskDetails;
    }

    private void sendToCost(QuantifyTask quantifyTask, List<QuantifyTaskDetail> quantifyTaskDetails) {
        if (CollectionUtils.isEmpty(quantifyTaskDetails)) {
            return;
        }
        ArrayList policyRewardConditionDtos = Lists.newArrayList();
        quantifyTaskDetails.forEach(detail -> {
            if (AutoSignEnum.YES.getCode().equals(detail.getProfitStatus())) {
                PolicyRewardConditionDto policyRewardConditionDto = new PolicyRewardConditionDto();
                policyRewardConditionDto.setPolicyName(this.quantifyPolicyMountRegister.getName());
                policyRewardConditionDto.setActualParticipatorFlag(ParticipatorTypeEnum.TERMINAL.getDictCode());
                policyRewardConditionDto.setActualParticipatorCode(quantifyTask.getTerminalCode());
                policyRewardConditionDto.setParticipatorFlag(ParticipatorTypeEnum.TERMINAL.getDictCode());
                policyRewardConditionDto.setParticipatorName(ParticipatorTypeEnum.TERMINAL.getValue());
                policyRewardConditionDto.setTemplateCode(quantifyTask.getTemplateId());
                policyRewardConditionDto.setRewardMethodFlag(detail.getRewardMethodFlag());
                policyRewardConditionDto.setRewardMethodName(detail.getRewardMethodName());
                policyRewardConditionDto.setAwardConditionFlag(detail.getAwardConditionFlag());
                policyRewardConditionDto.setAwardConditionName(detail.getAwardConditionName());
                policyRewardConditionDto.setRewardData(detail.getRewardData().toString());
                policyRewardConditionDto.setTriggerAction(this.quantifyPolicyMountRegister.getName());
                policyRewardConditionDto.setTriggerObject(quantifyTask.getBusinessCode());
                policyRewardConditionDto.setAgreementCode(quantifyTask.getAgreementId());
                policyRewardConditionDto.setGiftCode(detail.getGiftCode());
                policyRewardConditionDto.setRebateType("\u5305\u91cf\u653f\u7b56\u5206\u5229");
                policyRewardConditionDtos.add(policyRewardConditionDto);
            }
        });
        if (!CollectionUtils.isEmpty((Collection)policyRewardConditionDtos) && !CollectionUtils.isEmpty(this.policyRewardServiceObservers)) {
            this.policyRewardServiceObservers.forEach(policyRewardServiceObserver -> policyRewardServiceObserver.createRewardRecord(policyRewardConditionDtos));
        }
    }

    private void updateQuantifyTask(QuantifyTask quantifyTask, List<QuantifyTaskDetail> quantifyTaskDetails) {
        if (CollectionUtils.isEmpty(quantifyTaskDetails)) {
            quantifyTask.setReachRate(BigDecimal.ZERO);
            quantifyTask.setTaskStatus(QuantifyTaskStatusEnum.STATUS_EXPIRED.getCode());
        }
        BigDecimal reachRate = BigDecimal.ZERO;
        String taskStatus = QuantifyTaskStatusEnum.STATUS_EXPIRED.getCode();
        Boolean bool = false;
        for (QuantifyTaskDetail detail : quantifyTaskDetails) {
            if (!AutoSignEnum.YES.getCode().equals(detail.getProfitStatus())) continue;
            bool = true;
            break;
        }
        for (QuantifyTaskDetail detail : quantifyTaskDetails) {
            reachRate = reachRate.add(detail.getReachRate());
            if (!detail.getProfitStatus().equals(AutoSignEnum.YES.getCode())) continue;
            taskStatus = QuantifyTaskStatusEnum.STATUS_COMPLETE.getCode();
        }
        quantifyTask.setReachRate(reachRate.divide(new BigDecimal(quantifyTaskDetails.size()), 4, RoundingMode.HALF_UP));
        quantifyTask.setTaskStatus(taskStatus);
        if (bool.booleanValue()) {
            quantifyTask.setProfitStatus(ProfitStatusEnum.STATUS_COMPLETE.getCode());
        }
        quantifyTask.setProfitTime(new Date());
        this.quantifyTaskRepository.updateById((Object)quantifyTask);
    }

    @Override
    @DynamicTaskService(cornExpression="1 0 0 * * ?", taskDesc="\u6bcf\u65e5\u66f4\u65b0\u5f85\u6267\u884c\u4efb\u52a1\u72b6\u6001")
    public void updateQuantifyTaskStatus() {
        List<QuantifyTask> quantifyTasks = this.quantifyTaskRepository.findByAgreementIdAndStatus(null, QuantifyTaskStatusEnum.STATUS_WAIT.getCode(), new Date());
        if (!CollectionUtils.isEmpty(quantifyTasks)) {
            quantifyTasks.forEach(quantifyTask -> quantifyTask.setTaskStatus(QuantifyTaskStatusEnum.STATUS_DOING.getCode()));
            this.quantifyTaskRepository.saveOrUpdateBatch(quantifyTasks);
        }
    }

    @Override
    @Transactional
    public void updateSaleQuantity(String productCode, String barCode) {
        Date now = new Date();
        LoginUserDetailsForCPS loginUser = (LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
        Validate.notNull((Object)loginUser, (String)"\u672a\u83b7\u53d6\u5230\u64cd\u4f5c\u7528\u6237\u4fe1\u606f", (Object[])new Object[0]);
        String terminalCode = loginUser.getConsumerCode();
        Validate.notBlank((CharSequence)terminalCode, (String)"\u7528\u6237\u5bf9\u5e94\u7684\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        BarCodeVo barCodeVo = this.barCodeVoService.findByBarCode(barCode);
        Validate.notNull((Object)barCodeVo, (String)"\u672a\u83b7\u53d6\u5230\u6761\u7801\u5bf9\u5e94\u7684\u914d\u7f6e\u4fe1\u606f", (Object[])new Object[0]);
        List<QuantifyTask> tasks = this.quantifyTaskRepository.findMaterialCurTaskByTerminalCodeAndProductCode(terminalCode, productCode);
        if (CollectionUtils.isEmpty(tasks)) {
            return;
        }
        BigDecimal countSales = BigDecimal.ZERO;
        if (this.saleStandardUnit.equals(BarCodeTypeEnum.BOX.getKey())) {
            countSales = countSales.add(barCodeVo.getStandardUnitBoxValue());
        } else if (this.saleStandardUnit.equals(BarCodeTypeEnum.BOTTLE.getKey())) {
            countSales = countSales.add(barCodeVo.getStandardUnitBottleValue());
        }
        ArrayList statistics = Lists.newArrayList();
        for (QuantifyTask task : tasks) {
            task.setSaleActual(Optional.ofNullable(task.getSaleActual()).orElse(BigDecimal.ZERO).add(countSales));
            QuantifyStatistics cur = new QuantifyStatistics();
            cur.setBusinessCode(task.getBusinessCode());
            cur.setBarCode(barCode);
            cur.setProductCode(productCode);
            cur.setAmount(countSales);
            cur.setCreateTime(now);
            cur.setTenantCode(TenantUtils.getTenantCode());
            statistics.add(cur);
        }
        log.info("updateSaleQuantity[{}]", (Object)JSONUtil.toJsonStr(tasks));
        log.info("statistics[{}]", (Object)JSONUtil.toJsonStr((Object)statistics));
        this.quantifyTaskRepository.saveOrUpdateBatch(tasks);
        this.quantifyStatisticsRepository.saveBatch(statistics);
    }

    private List<QuantifyTaskDetail> calculateWithOnlyHighestLevel(QuantifyTask quantifyTask, BigDecimal scanCount, BigDecimal reachRate) {
        ArrayList quantifyTaskDetails = Lists.newArrayList();
        if (CollectionUtils.isEmpty(quantifyTask.getQuantifyTaskExpressions())) {
            return quantifyTaskDetails;
        }
        quantifyTask.getQuantifyTaskExpressions().sort((o1, o2) -> o2.getReachRate().compareTo(o1.getReachRate()));
        BigDecimal alreadyReachRate = null;
        for (QuantifyTaskExpression expression : quantifyTask.getQuantifyTaskExpressions()) {
            QuantifyTaskDetail quantifyTaskDetail = (QuantifyTaskDetail)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)expression, QuantifyTaskDetail.class, Set.class, ArrayList.class, new String[0]));
            quantifyTaskDetail.setId(null);
            quantifyTaskDetail.setBusinessCode(quantifyTask.getBusinessCode());
            quantifyTaskDetail.setSaleTarget(quantifyTask.getSaleTarget());
            quantifyTaskDetail.setActualSales(scanCount);
            quantifyTaskDetail.setReachRate(reachRate);
            if (!Objects.isNull(alreadyReachRate)) {
                if (alreadyReachRate.compareTo(expression.getReachRate()) == 0) {
                    quantifyTaskDetail.setProfitStatus(reachRate.compareTo(expression.getReachRate()) > -1 ? AutoSignEnum.YES.getCode() : AutoSignEnum.NO.getCode());
                } else {
                    quantifyTaskDetail.setProfitStatus(AutoSignEnum.NO.getCode());
                }
            } else {
                quantifyTaskDetail.setProfitStatus(reachRate.compareTo(expression.getReachRate()) > -1 ? AutoSignEnum.YES.getCode() : AutoSignEnum.NO.getCode());
                alreadyReachRate = quantifyTaskDetail.getProfitStatus().equals(AutoSignEnum.YES.getCode()) ? expression.getReachRate() : null;
            }
            quantifyTaskDetails.add(quantifyTaskDetail);
        }
        return quantifyTaskDetails;
    }

    private List<QuantifyTaskDetail> calculateWithAllLevel(QuantifyTask quantifyTask, BigDecimal scanCount, BigDecimal reachRate) {
        ArrayList quantifyTaskDetails = Lists.newArrayList();
        if (CollectionUtils.isEmpty(quantifyTask.getQuantifyTaskExpressions())) {
            return quantifyTaskDetails;
        }
        for (QuantifyTaskExpression expression : quantifyTask.getQuantifyTaskExpressions()) {
            QuantifyTaskDetail quantifyTaskDetail = (QuantifyTaskDetail)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)expression, QuantifyTaskDetail.class, Set.class, ArrayList.class, new String[0]));
            quantifyTaskDetail.setId(null);
            quantifyTaskDetail.setBusinessCode(quantifyTask.getBusinessCode());
            quantifyTaskDetail.setSaleTarget(quantifyTask.getSaleTarget());
            quantifyTaskDetail.setActualSales(scanCount);
            quantifyTaskDetail.setReachRate(reachRate);
            quantifyTaskDetail.setProfitStatus(reachRate.compareTo(expression.getReachRate()) > -1 ? AutoSignEnum.YES.getCode() : AutoSignEnum.NO.getCode());
            quantifyTaskDetails.add(quantifyTaskDetail);
        }
        return quantifyTaskDetails;
    }
}

