/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.quantify.fiscal.local.service.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.bisiness.policy.quantify.sdk.enums.QuantityTaskTypeEnums;
import com.biz.crm.cps.bisiness.policy.quantify.sdk.service.ScanCodeQuantityTaskVoService;
import com.biz.crm.cps.bisiness.policy.quantify.sdk.vo.ScanCodeQuantityTaskItemVo;
import com.biz.crm.cps.bisiness.policy.quantify.sdk.vo.ScanCodeQuantityTaskVo;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.entity.QuantifyTask;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.repository.QuantifyTaskRepository;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ScanCodeQuantityTaskVoServiceImpl
implements ScanCodeQuantityTaskVoService {
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired
    private QuantifyTaskRepository quantifyTaskRepository;

    public List<ScanCodeQuantityTaskVo> findScanCodeQuantityTaskVoList() {
        LoginUserDetailsForCPS loginUser = (LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
        Validate.notNull((Object)loginUser, (String)"\u672a\u83b7\u53d6\u5230\u64cd\u4f5c\u7528\u6237\u4fe1\u606f", (Object[])new Object[0]);
        String terminalCode = loginUser.getConsumerCode();
        Validate.notBlank((CharSequence)terminalCode, (String)"\u7528\u6237\u5bf9\u5e94\u7684\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<QuantifyTask> tasks = this.quantifyTaskRepository.findCurTaskByTerminalCode(terminalCode);
        if (CollectionUtils.isEmpty(tasks)) {
            return null;
        }
        Map<String, List<QuantifyTask>> map = tasks.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getAgreementId())).collect(Collectors.groupingBy(QuantifyTask::getAgreementId));
        ArrayList list = Lists.newArrayList();
        for (Map.Entry<String, List<QuantifyTask>> item : map.entrySet()) {
            ScanCodeQuantityTaskVo cur = new ScanCodeQuantityTaskVo();
            cur.setTaskName(item.getValue().get(0).getAgreementName());
            ArrayList curList = Lists.newArrayList();
            HashMap mapItem = Maps.newHashMap();
            Map curMap = item.getValue().stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getTaskType())).collect(Collectors.toMap(QuantifyTask::getTaskType, Function.identity(), (a, b) -> b));
            for (QuantityTaskTypeEnums typeEnums : QuantityTaskTypeEnums.values()) {
                QuantifyTask task = (QuantifyTask)((Object)curMap.get(typeEnums.getCode()));
                if (Objects.isNull((Object)task)) continue;
                curList.add(typeEnums.getDesc());
                ScanCodeQuantityTaskItemVo curVo = new ScanCodeQuantityTaskItemVo();
                curVo.setSaleTarget(Optional.ofNullable(task.getSaleTarget()).orElse(BigDecimal.ZERO));
                curVo.setSaleActual(Optional.ofNullable(task.getSaleActual()).orElse(BigDecimal.ZERO));
                if (BigDecimal.ZERO.compareTo(curVo.getSaleTarget()) < 0) {
                    curVo.setReachRate(curVo.getSaleActual().divide(curVo.getSaleTarget(), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100)));
                }
                mapItem.put(typeEnums.getDesc(), curVo);
            }
            cur.setMap((Map)mapItem);
            cur.setTimeKeyList((List)curList);
            list.add(cur);
        }
        return list;
    }
}

