/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.quantify.fiscal.local.service.notifier;

import cn.hutool.json.JSONUtil;
import com.biz.crm.cps.business.policy.quantify.fiscal.local.service.QuantifyTaskService;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordEventDto;
import com.biz.crm.cps.external.barcode.sdk.event.ScanCodeRecordEventListener;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class QuantifyFiscalEventListenerImpl
implements ScanCodeRecordEventListener {
    private static final Logger log = LoggerFactory.getLogger(QuantifyFiscalEventListenerImpl.class);
    private static final String TERMINAL = "terminal";
    @Autowired
    private QuantifyTaskService quantifyTaskService;

    @Transactional
    public void onSuccessScan(ScanCodeRecordEventDto dto) {
        log.info("\u8d22\u5e74\u5305\u91cf\u653f\u7b56\u626b\u7801\u4e8b\u4ef6\u5b9e\u73b0\u5904\u7406[{}]", (Object)JSONUtil.toJsonStr((Object)dto));
        if (Objects.isNull(dto) || !TERMINAL.equals(dto.getParticipatorType()) || StringUtils.isBlank((CharSequence)dto.getBarCode()) || StringUtils.isBlank((CharSequence)dto.getProductCode())) {
            return;
        }
        this.quantifyTaskService.updateSaleQuantity(dto.getProductCode(), dto.getBarCode());
    }

    public void onFailScan(ScanCodeRecordEventDto dto) {
    }
}

