package com.biz.crm.cps.business.policy.scan.cycle.local.controller;

import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.policy.scan.cycle.local.entity.ScanCodeConfiguration;
import com.biz.crm.cps.business.policy.scan.cycle.local.service.ScanCodeConfigurationService;
import com.biz.crm.cps.business.policy.scan.cycle.local.service.dynamictask.ScanCodeDynamicTask;
import com.biz.crm.cps.business.policy.scan.sdk.common.constant.ScanCodeConstant;
import com.biz.crm.cps.business.policy.scan.sdk.dto.ScanCodeConfigurationDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @author hefan
 */
@Api(tags = "分利政策---扫码政策")
@Slf4j
@RestController
@RequestMapping("/v1/policy/scan")
public class ScanCodeConfigurationController {

  @Resource
  private ScanCodeConfigurationService scanCodeConfigurationService;

  @Autowired
  private ScanCodeDynamicTask scanCodeDynamicTask;

  /**
   * fixme
   * 该接口为开发调试功能时使用的。前端不可调用
   */
  @ApiOperation(value = "相关的创建过程，http接口。请注意该创建过程除了可以创建terminal中的基本信息以外，还可以对terminal中属于OneToMany关联的明细信息一同进行创建注意：基于（Terminal）模型的创建操作传入的terminalJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PostMapping(value = "")
  public Result<ScanCodeConfiguration> create(@RequestBody @ApiParam(name = "scanCodeConfigurationDto", value = "") ScanCodeConfigurationDto scanCodeConfigurationDto) {
    try {
      ScanCodeConfiguration current = this.scanCodeConfigurationService.create(scanCodeConfigurationDto);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * fixme
   * 手动执行奖励任务，该接口为开发调试功能时使用的。前端不可调用
   */
  @ApiOperation(value = "手动执行奖励任务，该接口为开发调试功能时使用的。前端不可调用")
  @PostMapping(value = "findByCycle")
  public Result<?> findByCycle(@ApiParam(name = "cycle", value = "") String cycle) {
    try {
      if (ScanCodeConstant.MONTH.equals(cycle)) {
        this.scanCodeDynamicTask.settleByMonth();
      }
      if (ScanCodeConstant.SEASON.equals(cycle)) {
        this.scanCodeDynamicTask.settleBySeason();
      }
      if (ScanCodeConstant.HALF_YEAR.equals(cycle)) {
        this.scanCodeDynamicTask.settleByHalfYear();
      }
      if (ScanCodeConstant.YEAR.equals(cycle)) {
        this.scanCodeDynamicTask.settleByYear();
      }
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
