package com.biz.crm.cps.business.policy.scan.cycle.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Set;

/**
 * 扫码政策配置行
 * @author hefan
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ScanCodeConfiguration", description = "扫码政策配置行")
@TableName("cycle_scan_code_configuration")
public class ScanCodeConfiguration extends TenantOpEntity {

  private static final long serialVersionUID = 4228363826820555441L;

  /**
   * 模板编码
   *   @Column(name = "template_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 协议模板id '")
   */
  @ApiModelProperty("模板编码")
  @TableField(value = "template_code")
  private String templateCode;

  /**
   * 扫码产品维度标识
   * @Column(name = "dimension_flag", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 扫码产品维度标识 '")
   */
  @ApiModelProperty("扫码产品维度标识")
  @TableField(value = "dimension_flag")
  private String dimensionFlag;

  /**
   * 扫码产品维度名称
   * @Column(name = "dimension_name", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 扫码产品维度名称 '")
   */
  @ApiModelProperty("扫码产品维度名称")
  @TableField(value = "dimension_name")
  private String dimensionName;

  /**
   * 扫码事件
   * @OneToMany(fetch = FetchType.LAZY,mappedBy = "scanCodeConfiguration")
   */
  @ApiModelProperty("扫码事件")
  @TableField(exist = false)
  private Set<ScanCodeEvent> scanCodeEvents;

  /**
   * 扫码政策的产品范围
   * @OneToMany(fetch = FetchType.LAZY,mappedBy = "scanCodeConfiguration")
   */
  @ApiModelProperty("扫码政策的产品范围")
  @TableField(exist = false)
  private Set<ScanCodeRange> scanCodeRanges;

}
