package com.biz.crm.cps.business.policy.scan.cycle.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Set;

/**
 * 扫码事件
 * @author hefan
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ScanCodeEvent", description = "扫码事件")
@TableName("cycle_scan_code_event")
public class ScanCodeEvent extends BaseIdEntity {

  private static final long serialVersionUID = 6003526954635201976L;

  /**
   * 扫码政策配置行
   *  @JoinColumn(name = "configuration_id" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 扫码政策配置行 '")
   *  @ManyToOne(fetch = FetchType.LAZY)
   */
  @ApiModelProperty("扫码政策配置行")
  @TableField(exist = false)
  private ScanCodeConfiguration scanCodeConfiguration;

  /**
   * 配置行ID
   *   @Column(name = "configuration_id" , nullable = false, columnDefinition = "VARCHAR(255) COMMENT ' 配置行ID '")
   */
  @ApiModelProperty("配置行ID")
  @TableField(value = "configuration_id")
  private String configurationId;

  /**
   * 扫码行为主体(分利参与者 标记）
   * @Column(name = "participator_flag", nullable = false, length = 16, columnDefinition = "VARCHAR(16) COMMENT ' 扫码行为主体(分利参与者 标记） '")
   */
  @ApiModelProperty("扫码行为主体(分利参与者 标记）")
  @TableField(value = "participator_flag")
  private String participatorFlag;

  /**
   * 扫码行为主体(分利参与者 中文名）
   * @Column(name = "participator_name", nullable = false, length = 16, columnDefinition = "VARCHAR(16) COMMENT ' 扫码行为主体(分利参与者 中文名） '")
   */
  @ApiModelProperty("扫码行为主体(分利参与者 中文名）")
  @TableField(value = "participator_name")
  private String participatorName;

  /**
   * 条码类型（箱、瓶、盖 标记）
   * @Column(name = "bar_code_type_flag", nullable = false, length = 16, columnDefinition = "VARCHAR(16) COMMENT ' 条码类型（箱、瓶、盖 标记） '")
   */
  @ApiModelProperty("条码类型（箱、瓶、盖 标记）")
  @TableField(value = "bar_code_type_flag")
  private String barCodeTypeFlag;

  /**
   * 条码类型（箱、瓶、盖 中文名）
   * @Column(name = "bar_code_type_name", nullable = false, length = 16, columnDefinition = "VARCHAR(16) COMMENT ' 条码类型（箱、瓶、盖 中文名） '")
   */
  @ApiModelProperty("条码类型（箱、瓶、盖 中文名）")
  @TableField(value = "bar_code_type_name")
  private String barCodeTypeName;

  /**
   * 扫码分利表达式
   * @OneToMany(fetch = FetchType.LAZY,mappedBy = "scanCodeEvent")
   */
  @ApiModelProperty("扫码分利表达式")
  @TableField(exist = false)
  private Set<ScanCodeExpression> scanCodeExpressions;

}
